<?php

namespace App\Actions\Fortify;

use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Auth;
use Laravel\Fortify\Contracts\RegisterResponse;

class CustomRegisterResponse implements RegisterResponse
{
    public function toResponse($request)
    {
        Auth::logout();

        $request->session()->invalidate();
        $request->session()->regenerateToken();

        if ($request->wantsJson()) {
            return new JsonResponse([
                'registered' => true,
                'logged_in' => false,
                'message' => 'Account created successfully. Please verify your email and then log in.',
            ], 201);
        }

        return redirect()->route('login')
            ->with('success', 'Account created successfully. Please verify your email and then log in.');
    }
}


