<?php

namespace App\Actions\Fortify;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Validation\ValidationException;
use Laravel\Fortify\Contracts\LoginResponse;
use Laravel\Fortify\Fortify;
use App\Models\User;

class AuthenticateUser
{
    public function __invoke(Request $request)
    {
        $user = User::where('email', $request->email)->first();

        // Return null to let Fortify handle failed attempts uniformly
        if (! $user) {
            return null;
        }

        if (! Hash::check($request->password, $user->password)) {
            return null;
        }

        // Enforce email verification with a clear validation error
        if (! $user->hasVerifiedEmail()) {
            throw ValidationException::withMessages([
                Fortify::username() => __('Please verify your email before logging in.'),
            ]);
        }

        // Fortify will call guard->login($user, remember)
        return $user;
    }
}
