<?php

namespace Modules\Contacts\Services\CrmIntegration;

interface CrmConnectorInterface
{
    /**
     * Test the connection to the CRM.
     *
     * @param array $credentials
     * @return bool
     * @throws \Exception
     */
    public function testConnection(array $credentials): bool;

    /**
     * Get contacts from the CRM.
     *
     * @param array $credentials
     * @param array $options
     * @return array
     * @throws \Exception
     */
    public function getContacts(array $credentials, array $options = []): array;

    /**
     * Get a single contact from the CRM.
     *
     * @param array $credentials
     * @param string $contactId
     * @return array|null
     * @throws \Exception
     */
    public function getContact(array $credentials, string $contactId): ?array;

    /**
     * Create a contact in the CRM.
     *
     * @param array $credentials
     * @param array $contactData
     * @return array
     * @throws \Exception
     */
    public function createContact(array $credentials, array $contactData): array;

    /**
     * Update a contact in the CRM.
     *
     * @param array $credentials
     * @param string $contactId
     * @param array $contactData
     * @return array
     * @throws \Exception
     */
    public function updateContact(array $credentials, string $contactId, array $contactData): array;

    /**
     * Delete a contact from the CRM.
     *
     * @param array $credentials
     * @param string $contactId
     * @return bool
     * @throws \Exception
     */
    public function deleteContact(array $credentials, string $contactId): bool;

    /**
     * Get available fields from the CRM.
     *
     * @param array $credentials
     * @return array
     * @throws \Exception
     */
    public function getAvailableFields(array $credentials): array;

    /**
     * Get the CRM type.
     *
     * @return string
     */
    public function getType(): string;

    /**
     * Get the CRM display name.
     *
     * @return string
     */
    public function getDisplayName(): string;

    /**
     * Get the required credentials for this CRM.
     *
     * @return array
     */
    public function getRequiredCredentials(): array;

    /**
     * Validate credentials format.
     *
     * @param array $credentials
     * @return bool
     */
    public function validateCredentials(array $credentials): bool;
}