# Customer Support Flow Documentation

## Overview
This flow implements a comprehensive customer support system that handles:
- Ticket/Case creation with automatic ticket number generation
- Order status checking and delivery information
- Product recommendations with links
- Customer service agent transfer functionality

## Flow Structure

### 1. Initial Trigger (keyword_trigger-0.1234567890123456)
**Keywords:** "hi", "hello", "help"
- Triggers the welcome message when customers initiate conversation

### 2. Welcome Message (welcome_message-0.1234567890123456)
**Type:** Message Node
- Provides overview of available services
- Lists all support options (tickets, status, products, agent transfer)

### 3. Ticket Creation Flow

#### 3.1 Ticket Trigger (ticket_trigger-0.2345678901234567)
**Keywords:** "ticket", "case", "problem", "issue"
- Detects when customer wants to create a support ticket

#### 3.2 Ticket Button Message (ticket_button_message-0.3456789012345678)
**Type:** Message Node
- Provides "Book Ticket" button for ticket creation
- Explains the ticket creation process

#### 3.3 Ticket Creation API (ticket_creation_api-0.4567890123456789)
**Type:** New Request Node
- **Method:** POST
- **URL:** `https://api.yourcompany.com/tickets/create`
- **Headers:** Authorization Bearer token
- **Body:** Customer phone, name, issue type, priority, status
- **Response Variables:**
  - `ticket_response`: Full API response
  - `ticket_number`: Generated ticket number
  - `ticket_status`: Ticket status (pending, in_progress, resolved)

#### 3.4 Ticket Success Message (ticket_success_message-0.5678901234567890)
**Type:** Message Node
- Displays ticket number and status
- Shows available branch locations
- Provides next steps options

### 4. Status Checking Flow

#### 4.1 Status Check Trigger (status_check_trigger-0.6789012345678901)
**Keywords:** "status", "check", "track", "delivery"
- Detects when customer wants to check ticket/order status

#### 4.2 Ask Ticket Number (ask_ticket_number-0.7890123456789012)
**Type:** Question Node
- Prompts customer to enter their ticket number
- Stores response in `user_ticket_number` variable

#### 4.3 Ticket Status API (ticket_status_api-0.8901234567890123)
**Type:** New Request Node
- **Method:** GET
- **URL:** `https://api.yourcompany.com/tickets/{{user_ticket_number}}/status`
- **Response Variables:**
  - `status_response`: Full API response
  - `ticket_status`: Current ticket status
  - `delivery_items`: List of delivery items
  - `estimated_delivery`: Estimated delivery time

#### 4.4 Status Response Message (status_response_message-0.9012345678901234)
**Type:** Message Node
- Displays ticket status and delivery information
- Shows available branch locations
- Provides additional options

### 5. Product Recommendations Flow

#### 5.1 Products Trigger (products_trigger-0.0123456789012345)
**Keywords:** "products", "items", "catalog", "shop"
- Detects when customer wants product information

#### 5.2 Ask Product Requirements (ask_product_requirements-0.1234567890123456)
**Type:** Question Node
- Prompts customer to describe their product needs
- Stores response in `product_requirements` variable

#### 5.3 Products API (products_api-0.2345678901234567)
**Type:** New Request Node
- **Method:** POST
- **URL:** `https://api.yourcompany.com/products/search`
- **Body:** Product requirements query and customer phone
- **Response Variables:**
  - `products_response`: Full API response
  - `product_list`: List of matching products
  - `product_links`: Product purchase links

#### 5.4 Products List Message (products_list_message-0.3456789012345678)
**Type:** Message Node
- Displays matching products with links
- Shows available branch locations
- Provides additional options

### 6. Agent Transfer Flow

#### 6.1 Agent Transfer Trigger (agent_transfer_trigger-0.4567890123456789)
**Keywords:** "agent", "human", "representative", "transfer"
- Detects when customer wants to speak with a human agent

#### 6.2 Agent Transfer Message (agent_transfer_message-0.5678901234567890)
**Type:** Message Node
- Confirms transfer to customer service agent
- Provides wait time information
- Offers alternative options

### 7. End Flow (end_flow-0.6789012345678901)
**Type:** End Node
- Terminates the conversation flow

## Key Features

### 1. Multi-Intent Recognition
- Uses keyword triggers to detect different customer intents
- Supports both exact and contains matching
- Handles multiple keywords per intent

### 2. API Integration
- **Ticket Creation API:** Creates support tickets with automatic numbering
- **Status Check API:** Retrieves ticket status and delivery information
- **Products API:** Searches and recommends products based on requirements

### 3. Branch Locations
All messages include information about available locations:
- 🏢 Main Office - Downtown
- 🏪 Branch 1 - Mall
- 🏬 Branch 2 - Airport

### 4. Variable Management
- Uses dynamic variables for personalization
- Stores user inputs for API calls
- Maintains conversation context

### 5. Error Handling
- API timeout and retry configurations
- Graceful fallback options
- Clear error messaging

## API Endpoints Required

### 1. Ticket Creation
```
POST https://api.yourcompany.com/tickets/create
Headers: Authorization: Bearer YOUR_API_TOKEN
Body: {
  "customer_phone": "{{contact_phone}}",
  "customer_name": "{{contact_name}}",
  "issue_type": "general",
  "priority": "medium",
  "status": "pending"
}
```

### 2. Ticket Status Check
```
GET https://api.yourcompany.com/tickets/{{user_ticket_number}}/status
Headers: Authorization: Bearer YOUR_API_TOKEN
```

### 3. Product Search
```
POST https://api.yourcompany.com/products/search
Headers: Authorization: Bearer YOUR_API_TOKEN
Body: {
  "query": "{{product_requirements}}",
  "customer_phone": "{{contact_phone}}",
  "limit": 10
}
```

## Configuration Requirements

### 1. API Tokens
- Replace `YOUR_API_TOKEN` with actual API tokens
- Configure proper authentication headers
- Set appropriate timeout values

### 2. Webhook URLs
- Update API endpoints to match your backend
- Configure proper error handling
- Set up response parsing

### 3. Branch Information
- Update location details in messages
- Configure branch-specific routing if needed
- Set up location-based services

## Usage Instructions

1. **Import the Flow:** Load `CustomerSupportFlow.json` into your Flowmaker system
2. **Configure APIs:** Update API endpoints and authentication tokens
3. **Test Keywords:** Verify all keyword triggers work correctly
4. **Test API Calls:** Ensure all HTTP requests return expected responses
5. **Deploy:** Activate the flow for customer interactions

## Customization Options

### 1. Additional Keywords
- Add more trigger keywords for better intent recognition
- Include synonyms and variations
- Support multiple languages

### 2. Enhanced Branching
- Add conditional logic based on customer type
- Implement priority-based routing
- Create location-specific flows

### 3. Advanced Features
- Add file upload capabilities for ticket attachments
- Implement real-time chat with agents
- Include payment processing for product purchases

## Monitoring and Analytics

### 1. Flow Metrics
- Track ticket creation rates
- Monitor status check frequency
- Analyze product search patterns

### 2. Customer Satisfaction
- Measure response times
- Track resolution rates
- Monitor agent transfer requests

### 3. Performance Optimization
- Optimize API response times
- Reduce conversation complexity
- Improve keyword matching accuracy