<?php

namespace Modules\Flowmaker\Models\Nodes;

use Illuminate\Support\Facades\Log;

class Every extends Node
{
    public function process($message, $data)
    {
        Log::info('Processing message in incoming message node', ['message' => $message, 'data' => $data]);

        // Get settings from node data
        $settings = $this->getDataAsArray()['settings'] ?? [];
        
        // Process only the first outgoing edge for incoming_message triggers
        if (!empty($this->outgoingEdges)) {
            $nextNode = $this->outgoingEdges[0]->getTarget();
            if ($nextNode) {
                $nextNode->process($message, $data);
            }
        }

        return [
            'success' => true
        ];
    }

    protected function getNextNodeId($param=null)
    {
        // Every node processes all outgoing edges, so we don't need to select just one
        // This method is included for compatibility with the Node parent class
        if (!empty($this->outgoingEdges)) {
            return $this->outgoingEdges[0]->getTarget();
        }
        return null;
    }
}
