@extends('layouts.app', ['title' => __('crm.crm_dashboard')])

@section('content')
<div class="header pb-8 pt-5 pt-md-8">
    <div class="container-fluid">
        <div class="header-body">
            <div class="row align-items-center py-4">
                <div class="col-lg-6 col-7">
                    <nav aria-label="breadcrumb" class="d-none d-md-inline-block ml-md-4">
                        <ol class="breadcrumb breadcrumb-links breadcrumb-dark">
                            <li class="breadcrumb-item"><a href="{{ route('contacts.index') }}"><i class="fas fa-home"></i></a></li>
                            <li class="breadcrumb-item"><a href="{{ route('contacts.index') }}">{{ __('Contacts') }}</a></li>
                            <li class="breadcrumb-item active" aria-current="page">{{ __('crm.crm_dashboard') }}</li>
                        </ol>
                    </nav>
                </div>
                <div class="col-lg-6 col-5 text-right">
                    <a href="{{ route('contacts.crm.create') }}" class="btn btn-sm btn-neutral">
                        <i class="fas fa-plus mr-2"></i>{{ __('crm.add_connection') }}
                    </a>
                </div>
            </div>
            <div class="row">
                <div class="col">
                    <div class="card shadow">
                        <div class="card-header border-0">
                            <div class="row align-items-center">
                                <div class="col">
                                    <h3 class="mb-0">
                                        <i class="fas fa-cloud-download-alt text-info mr-2"></i>
                                        {{ __('crm.crm_dashboard') }}
                                    </h3>
                                    <p class="text-muted mb-0">{{ __('crm.manage_crm_connections') }}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="container-fluid mt--7">

    <!-- Statistics Cards -->
    <div class="row">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card card-stats mb-4 mb-xl-0 shadow-sm border-0 position-relative overflow-hidden">
                <div class="card-body">
                    <div class="row">
                        <div class="col">
                            <h5 class="card-title text-uppercase text-muted mb-1 font-weight-600">{{ __('crm.total_connections') }}</h5>
                            <span class="h2 font-weight-bold mb-0 text-primary">{{ $stats['total_connections'] }}</span>
                            <div class="text-xs text-muted mt-1">
                                <i class="fas fa-info-circle mr-1"></i>All CRM connections
                            </div>
                        </div>
                        <div class="col-auto">
                            <div class="icon icon-shape bg-gradient-primary text-white rounded-circle shadow-lg">
                                <i class="fas fa-plug"></i>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-footer bg-primary-light py-2">
                    <small class="text-primary font-weight-bold">
                        <i class="fas fa-arrow-up mr-1"></i>Active
                    </small>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card card-stats mb-4 mb-xl-0 shadow-sm border-0 position-relative overflow-hidden">
                <div class="card-body">
                    <div class="row">
                        <div class="col">
                            <h5 class="card-title text-uppercase text-muted mb-1 font-weight-600">{{ __('crm.active_connections') }}</h5>
                            <span class="h2 font-weight-bold mb-0 text-success">{{ $stats['active_connections'] }}</span>
                            <div class="text-xs text-muted mt-1">
                                <i class="fas fa-check-circle mr-1"></i>Ready to use
                            </div>
                        </div>
                        <div class="col-auto">
                            <div class="icon icon-shape bg-gradient-success text-white rounded-circle shadow-lg">
                                <i class="fas fa-check-circle"></i>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-footer bg-success-light py-2">
                    <small class="text-success font-weight-bold">
                        <i class="fas fa-heartbeat mr-1"></i>Healthy
                    </small>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card card-stats mb-4 mb-xl-0 shadow-sm border-0 position-relative overflow-hidden">
                <div class="card-body">
                    <div class="row">
                        <div class="col">
                            <h5 class="card-title text-uppercase text-muted mb-1 font-weight-600">{{ __('crm.successful_imports') }}</h5>
                            <span class="h2 font-weight-bold mb-0 text-info">{{ $stats['successful_imports'] }}</span>
                            <div class="text-xs text-muted mt-1">
                                <i class="fas fa-chart-line mr-1"></i>This month
                            </div>
                        </div>
                        <div class="col-auto">
                            <div class="icon icon-shape bg-gradient-info text-white rounded-circle shadow-lg">
                                <i class="fas fa-download"></i>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-footer bg-info-light py-2">
                    <small class="text-info font-weight-bold">
                        <i class="fas fa-trending-up mr-1"></i>Growing
                    </small>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card card-stats mb-4 mb-xl-0 shadow-sm border-0 position-relative overflow-hidden">
                <div class="card-body">
                    <div class="row">
                        <div class="col">
                            <h5 class="card-title text-uppercase text-muted mb-1 font-weight-600">{{ __('crm.failed_imports') }}</h5>
                            <span class="h2 font-weight-bold mb-0 text-warning">{{ $stats['failed_imports'] }}</span>
                            <div class="text-xs text-muted mt-1">
                                <i class="fas fa-exclamation-triangle mr-1"></i>Need attention
                            </div>
                        </div>
                        <div class="col-auto">
                            <div class="icon icon-shape bg-gradient-warning text-white rounded-circle shadow-lg">
                                <i class="fas fa-exclamation-triangle"></i>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-footer bg-warning-light py-2">
                    <small class="text-warning font-weight-bold">
                        <i class="fas fa-tools mr-1"></i>Review needed
                    </small>
                </div>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <div class="row mt-5">
        <!-- CRM Connections -->
        <div class="col-lg-8">
            <div class="card shadow mb-4">
                <div class="card-header py-4 d-flex justify-content-between align-items-center">
                    <h4 class="m-0 font-weight-bold text-primary">
                        <i class="fas fa-plug mr-2"></i>{{ __('crm.crm_connections') }}
                    </h4>
                    <div>
                        <a href="{{ route('contacts.crm.credentials-guide') }}" class="btn btn-outline-info btn-lg rounded-pill px-4 mr-3 shadow-sm">
                            <i class="fas fa-question-circle mr-2"></i>{{ __('crm.credentials_guide') }}
                        </a>
                        <a href="{{ route('contacts.crm.create') }}" class="btn btn-primary btn-lg rounded-pill px-4 shadow-sm">
                            <i class="fas fa-plus mr-2"></i>{{ __('crm.add_connection') }}
                        </a>
                    </div>
                </div>
                <div class="card-body p-0">
                    @if($connections->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-hover mb-0" id="connectionsTable" width="100%" cellspacing="0">
                                <thead class="thead-light">
                                    <tr>
                                        <th class="border-0 py-3 px-4 font-weight-bold text-uppercase text-xs">{{ __('crm.connection_name') }}</th>
                                        <th class="border-0 py-3 px-4 font-weight-bold text-uppercase text-xs">{{ __('crm.type') }}</th>
                                        <th class="border-0 py-3 px-4 font-weight-bold text-uppercase text-xs">{{ __('crm.status') }}</th>
                                        <th class="border-0 py-3 px-4 font-weight-bold text-uppercase text-xs">{{ __('crm.health') }}</th>
                                        <th class="border-0 py-3 px-4 font-weight-bold text-uppercase text-xs">{{ __('crm.last_sync') }}</th>
                                        <th class="border-0 py-3 px-4 font-weight-bold text-uppercase text-xs text-center">{{ __('crm.actions') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($connections as $connection)
                                        <tr class="border-bottom">
                                            <td class="py-4 px-4">
                                                <div class="d-flex align-items-center">
                                                    <div class="mr-3">
                                                        @if($connection->type === 'hubspot')
                                                            <div class="bg-orange rounded-circle d-flex align-items-center justify-content-center" style="width: 40px; height: 40px;">
                                                                <i class="fab fa-hubspot text-white fa-lg"></i>
                                                            </div>
                                                        @elseif($connection->type === 'salesforce')
                                                            <div class="bg-info rounded-circle d-flex align-items-center justify-content-center" style="width: 40px; height: 40px;">
                                                                <i class="fab fa-salesforce text-white fa-lg"></i>
                                                            </div>
                                                        @elseif($connection->type === 'pipedrive')
                                                            <div class="bg-success rounded-circle d-flex align-items-center justify-content-center" style="width: 40px; height: 40px;">
                                                                <i class="fas fa-chart-line text-white fa-lg"></i>
                                                            </div>
                                                        @else
                                                            <div class="bg-secondary rounded-circle d-flex align-items-center justify-content-center" style="width: 40px; height: 40px;">
                                                                <i class="fas fa-cloud text-white fa-lg"></i>
                                                            </div>
                                                        @endif
                                                    </div>
                                                    <div>
                                                        <div class="font-weight-bold text-dark">{{ $connection->name }}</div>
                                                        <small class="text-muted">{{ $connection->description ?? 'CRM Connection' }}</small>
                                                    </div>
                                                </div>
                                            </td>
                                            <td class="py-4 px-4">
                                                <span class="badge badge-pill badge-primary font-weight-normal">{{ strtoupper($connection->type) }}</span>
                                            </td>
                                            <td class="py-4 px-4">
                                                @if($connection->is_active)
                                                    <span class="badge badge-pill badge-success">
                                                        <i class="fas fa-check mr-1"></i>{{ __('crm.active') }}
                                                    </span>
                                                @else
                                                    <span class="badge badge-pill badge-secondary">
                                                        <i class="fas fa-pause mr-1"></i>{{ __('crm.inactive') }}
                                                    </span>
                                                @endif
                                            </td>
                                            <td class="py-4 px-4">
                                                @if($connection->is_healthy)
                                                    <span class="badge badge-pill badge-success">
                                                        <i class="fas fa-heartbeat mr-1"></i>{{ __('crm.healthy') }}
                                                    </span>
                                                @else
                                                    <span class="badge badge-pill badge-danger">
                                                        <i class="fas fa-exclamation-triangle mr-1"></i>{{ __('crm.unhealthy') }}
                                                    </span>
                                                @endif
                                            </td>
                                            <td class="py-4 px-4">
                                                @if($connection->last_sync_at)
                                                    <div class="text-sm">
                                                        <div class="font-weight-bold text-dark">{{ $connection->last_sync_at->format('M j, Y') }}</div>
                                                        <small class="text-muted">
                                                            <i class="fas fa-clock mr-1"></i>{{ $connection->last_sync_at->diffForHumans() }}
                                                        </small>
                                                    </div>
                                                @else
                                                    <span class="text-muted">
                                                        <i class="fas fa-minus mr-1"></i>{{ __('crm.never') }}
                                                    </span>
                                                @endif
                                            </td>
                                            <td class="py-4 px-4 text-center">
                                                <div class="d-flex justify-content-center">
                                                    <div class="btn-group btn-group-sm" role="group">
                                                        <a href="{{ route('contacts.crm.show', $connection) }}" 
                                                           class="btn btn-outline-primary rounded-pill mr-1" 
                                                           title="{{ __('crm.view_details') }}"
                                                           style="width: 36px; height: 36px; display: flex; align-items: center; justify-content: center;">
                                                            <i class="fas fa-eye"></i>
                                                        </a>
                                                        <a href="{{ route('contacts.crm.edit', $connection) }}" 
                                                           class="btn btn-outline-warning rounded-pill mr-1" 
                                                           title="{{ __('crm.edit_connection') }}"
                                                           style="width: 36px; height: 36px; display: flex; align-items: center; justify-content: center;">
                                                            <i class="fas fa-edit"></i>
                                                        </a>
                                                        @if($connection->is_healthy)
                                                            <a href="{{ route('contacts.crm-import.index') }}?connection={{ $connection->id }}" 
                                                               class="btn btn-outline-success rounded-pill mr-1" 
                                                               title="{{ __('crm.import_contacts') }}"
                                                               style="width: 36px; height: 36px; display: flex; align-items: center; justify-content: center;">
                                                                <i class="fas fa-download"></i>
                                                            </a>
                                                        @endif
                                                        <button type="button" 
                                                                class="btn btn-outline-{{ $connection->is_active ? 'warning' : 'success' }} rounded-pill mr-1" 
                                                                data-connection-id="{{ $connection->id }}"
                                                                onclick="toggleConnectionStatus(this)"
                                                                title="{{ $connection->is_active ? __('crm.deactivate') : __('crm.activate') }}"
                                                                style="width: 36px; height: 36px; display: flex; align-items: center; justify-content: center;">
                                                            <i class="fas fa-{{ $connection->is_active ? 'pause' : 'play' }}"></i>
                                                        </button>
                                                        <button type="button" 
                                                                class="btn btn-outline-danger rounded-pill" 
                                                                data-connection-id="{{ $connection->id }}"
                                                                onclick="deleteConnection(this)"
                                                                title="{{ __('crm.delete_connection') }}"
                                                                style="width: 36px; height: 36px; display: flex; align-items: center; justify-content: center;">
                                                            <i class="fas fa-trash"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        
                        <!-- Pagination -->
                        <div class="d-flex justify-content-center">
                            {{ $connections->links() }}
                        </div>
                    @else
                        <div class="text-center py-5 px-4">
                            <div class="mb-4">
                                <div class="bg-light rounded-circle d-inline-flex align-items-center justify-content-center" style="width: 80px; height: 80px;">
                                    <i class="fas fa-plug fa-2x text-muted"></i>
                                </div>
                            </div>
                            <h4 class="text-gray-600 mb-2">{{ __('crm.no_connections_found') }}</h4>
                            <p class="text-muted mb-4">{{ __('crm.create_first_connection') }}</p>
                            <a href="{{ route('contacts.crm.create') }}" class="btn btn-primary btn-lg rounded-pill px-4">
                                <i class="fas fa-plus mr-2"></i>{{ __('crm.add_connection') }}
                            </a>
                        </div>
                    @endif
                </div>
            </div>
        </div>

        <!-- Recent Import History -->
        <div class="col-lg-4">
            <div class="card shadow mb-4">
                <div class="card-header py-4 d-flex justify-content-between align-items-center">
                    <h4 class="m-0 font-weight-bold text-primary">
                        <i class="fas fa-history mr-2"></i>{{ __('crm.recent_imports') }}
                    </h4>
                    <a href="{{ route('contacts.crm-import.history') }}" class="btn btn-outline-primary rounded-pill px-3">
                        <i class="fas fa-arrow-right mr-1"></i>{{ __('crm.view_all') }}
                    </a>
                </div>
                <div class="card-body p-0">
                    @if($recentImports->count() > 0)
                        <div class="list-group list-group-flush">
                            @foreach($recentImports as $import)
                                <div class="list-group-item border-0 py-4 px-4 hover-bg-light">
                                    <div class="d-flex align-items-center">
                                        <div class="flex-shrink-0 mr-3">
                                            @if($import->status === 'completed')
                                                <div class="bg-success rounded-circle d-flex align-items-center justify-content-center shadow-sm" style="width: 48px; height: 48px;">
                                                    <i class="fas fa-check text-white fa-lg"></i>
                                                </div>
                                            @elseif($import->status === 'failed')
                                                <div class="bg-danger rounded-circle d-flex align-items-center justify-content-center shadow-sm" style="width: 48px; height: 48px;">
                                                    <i class="fas fa-times text-white fa-lg"></i>
                                                </div>
                                            @elseif($import->status === 'in_progress')
                                                <div class="bg-info rounded-circle d-flex align-items-center justify-content-center shadow-sm" style="width: 48px; height: 48px;">
                                                    <i class="fas fa-spinner fa-spin text-white fa-lg"></i>
                                                </div>
                                            @else
                                                <div class="bg-warning rounded-circle d-flex align-items-center justify-content-center shadow-sm" style="width: 48px; height: 48px;">
                                                    <i class="fas fa-clock text-white fa-lg"></i>
                                                </div>
                                            @endif
                                        </div>
                                        <div class="flex-grow-1">
                                            <div class="d-flex justify-content-between align-items-start mb-2">
                                                <h6 class="mb-0 font-weight-bold text-dark">{{ $import->crmConnection->name ?? 'Unknown Connection' }}</h6>
                                                <span class="badge badge-{{ $import->status === 'completed' ? 'success' : ($import->status === 'failed' ? 'danger' : 'info') }} badge-pill font-weight-normal">
                                                    {{ strtoupper($import->status) }}
                                                </span>
                                            </div>
                                            <div class="d-flex align-items-center mb-2">
                                                <span class="text-muted mr-3">
                                                    <i class="fas fa-database mr-1"></i>{{ $import->total_records ?? 0 }} {{ __('crm.records') }}
                                                </span>
                                                @if($import->status === 'completed' && $import->successful_records > 0)
                                                    <span class="text-success mr-3">
                                                        <i class="fas fa-check-circle mr-1"></i>{{ $import->successful_records }} {{ __('crm.successful') }}
                                                    </span>
                                                @endif
                                            </div>
                                            <div class="d-flex align-items-center">
                                                <small class="text-muted">
                                                    <i class="fas fa-clock mr-1"></i>{{ $import->created_at->diffForHumans() }}
                                                </small>
                                                @if($import->status === 'completed' && $import->successful_records > 0)
                                                    <div class="ml-auto">
                                                        <div class="progress" style="width: 60px; height: 4px;">
                                                            <div class="progress-bar bg-success" style="width: 100%"></div>
                                                        </div>
                                                    </div>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @else
                        <div class="text-center py-5">
                            <i class="fas fa-history fa-3x text-gray-300 mb-3"></i>
                            <h5 class="text-muted mb-2">{{ __('crm.no_imports_yet') }}</h5>
                            <p class="text-muted mb-0">Start importing contacts from your CRM</p>
                        </div>
                    @endif
                </div>
            </div>

            <!-- Quick Actions -->
            <div class="card shadow">
                <div class="card-header py-4">
                    <h4 class="m-0 font-weight-bold text-primary">
                        <i class="fas fa-bolt mr-2"></i>{{ __('crm.quick_actions') }}
                    </h4>
                </div>
                <div class="card-body p-0">
                    <div class="list-group list-group-flush">
                        <!-- Add New Connection -->
                        <a href="{{ route('contacts.crm.create') }}" class="list-group-item list-group-item-action border-0 py-4 quick-action-item">
                            <div class="d-flex align-items-center">
                                <div class="flex-shrink-0 mr-3">
                                    <div class="bg-primary rounded-circle d-flex align-items-center justify-content-center shadow-sm" style="width: 50px; height: 50px;">
                                        <i class="fas fa-plus text-white fa-lg"></i>
                                    </div>
                                </div>
                                <div class="flex-grow-1">
                                    <h5 class="mb-1 font-weight-bold text-primary">{{ __('crm.add_connection') }}</h5>
                                    <p class="text-muted mb-0 small">Create a new CRM connection</p>
                                </div>
                                <div class="flex-shrink-0">
                                    <i class="fas fa-chevron-right text-muted"></i>
                                </div>
                            </div>
                        </a>
                        
                        <!-- Import Contacts -->
                        <a href="{{ route('contacts.crm-import.index') }}" class="list-group-item list-group-item-action border-0 py-4 quick-action-item">
                            <div class="d-flex align-items-center">
                                <div class="flex-shrink-0 mr-3">
                                    <div class="bg-success rounded-circle d-flex align-items-center justify-content-center shadow-sm" style="width: 50px; height: 50px;">
                                        <i class="fas fa-download text-white fa-lg"></i>
                                    </div>
                                </div>
                                <div class="flex-grow-1">
                                    <h5 class="mb-1 font-weight-bold text-success">{{ __('crm.import_contacts') }}</h5>
                                    <p class="text-muted mb-0 small">Import contacts from your CRM</p>
                                </div>
                                <div class="flex-shrink-0">
                                    <i class="fas fa-chevron-right text-muted"></i>
                                </div>
                            </div>
                        </a>
                        
                        <!-- View Import History -->
                        <a href="{{ route('contacts.crm-import.history') }}" class="list-group-item list-group-item-action border-0 py-4 quick-action-item">
                            <div class="d-flex align-items-center">
                                <div class="flex-shrink-0 mr-3">
                                    <div class="bg-info rounded-circle d-flex align-items-center justify-content-center shadow-sm" style="width: 50px; height: 50px;">
                                        <i class="fas fa-history text-white fa-lg"></i>
                                    </div>
                                </div>
                                <div class="flex-grow-1">
                                    <h5 class="mb-1 font-weight-bold text-info">{{ __('crm.view_import_history') }}</h5>
                                    <p class="text-muted mb-0 small">View past import activities</p>
                                </div>
                                <div class="flex-shrink-0">
                                    <i class="fas fa-chevron-right text-muted"></i>
                                </div>
                            </div>
                        </a>
                        
                        <!-- Credentials Guide -->
                        <a href="{{ route('contacts.crm.credentials-guide') }}" class="list-group-item list-group-item-action border-0 py-4 quick-action-item">
                            <div class="d-flex align-items-center">
                                <div class="flex-shrink-0 mr-3">
                                    <div class="bg-warning rounded-circle d-flex align-items-center justify-content-center shadow-sm" style="width: 50px; height: 50px;">
                                        <i class="fas fa-question-circle text-white fa-lg"></i>
                                    </div>
                                </div>
                                <div class="flex-grow-1">
                                    <h5 class="mb-1 font-weight-bold text-warning">{{ __('crm.credentials_guide') }}</h5>
                                    <p class="text-muted mb-0 small">Get help with CRM credentials</p>
                                </div>
                                <div class="flex-shrink-0">
                                    <i class="fas fa-chevron-right text-muted"></i>
                                </div>
                            </div>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Delete Confirmation Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ __('crm.delete_connection') }}</h5>
                <button type="button" class="close" data-dismiss="modal">
                    <span>&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <p>{{ __('crm.delete_connection_confirmation') }}</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">{{ __('crm.cancel') }}</button>
                <button type="button" class="btn btn-danger" id="confirmDelete">{{ __('crm.delete') }}</button>
            </div>
        </div>
    </div>
</div>
</div>
@endsection

@push('css')
<style>
/* Enhanced Statistics Cards */
.card-stats {
    transition: all 0.3s ease;
    border: none !important;
}

.card-stats:hover {
    transform: translateY(-2px);
    box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15) !important;
}

.card-footer {
    border-top: 1px solid rgba(0, 0, 0, 0.05);
    background: rgba(0, 0, 0, 0.02);
}

/* Enhanced Table Styling */
.table-hover tbody tr:hover {
    background-color: rgba(0, 123, 255, 0.05);
    transform: scale(1.01);
    transition: all 0.2s ease;
}

.table th {
    border-top: none;
    font-weight: 600;
    letter-spacing: 0.5px;
}

.table td {
    vertical-align: middle;
    border-top: 1px solid rgba(0, 0, 0, 0.05);
}

/* Enhanced Action Buttons */
.btn-outline-primary:hover,
.btn-outline-warning:hover,
.btn-outline-success:hover,
.btn-outline-danger:hover {
    transform: scale(1.1);
    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.15);
}

/* Quick Actions Hover Effects */
.quick-action-item {
    transition: all 0.3s ease;
    border-radius: 8px !important;
    margin: 0 8px 4px 8px;
}

.quick-action-item:hover {
    background-color: rgba(0, 123, 255, 0.05) !important;
    transform: translateX(4px);
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
}

.quick-action-item:hover .fas.fa-chevron-right {
    transform: translateX(4px);
    transition: transform 0.3s ease;
}

/* Recent Imports Hover Effects */
.hover-bg-light:hover {
    background-color: rgba(0, 123, 255, 0.03) !important;
    transition: background-color 0.3s ease;
}

/* Enhanced Badges */
.badge-pill {
    font-size: 0.75rem;
    padding: 0.5em 0.75em;
}

/* Progress Bars */
.progress {
    border-radius: 10px;
    overflow: hidden;
}

.progress-bar {
    transition: width 0.6s ease;
}

/* Loading States */
.btn:disabled {
    opacity: 0.6;
    cursor: not-allowed;
}

/* Custom Scrollbar */
.table-responsive::-webkit-scrollbar {
    height: 6px;
}

.table-responsive::-webkit-scrollbar-track {
    background: #f1f1f1;
    border-radius: 3px;
}

.table-responsive::-webkit-scrollbar-thumb {
    background: #c1c1c1;
    border-radius: 3px;
}

.table-responsive::-webkit-scrollbar-thumb:hover {
    background: #a8a8a8;
}

/* Animation for status changes */
@keyframes pulse {
    0% { transform: scale(1); }
    50% { transform: scale(1.05); }
    100% { transform: scale(1); }
}

.badge-success {
    animation: pulse 2s infinite;
}

/* Enhanced Empty States */
.text-center.py-5 {
    background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
    border-radius: 8px;
    margin: 16px;
}

/* Card Headers */
.card-header {
    background: linear-gradient(135deg, #ffffff 0%, #f8f9fa 100%);
    border-bottom: 1px solid rgba(0, 0, 0, 0.05);
}

/* Responsive Improvements */
@media (max-width: 768px) {
    .btn-group-sm .btn {
        width: 32px;
        height: 32px;
        font-size: 0.8rem;
    }
    
    .quick-action-item {
        margin: 0 4px 2px 4px;
    }
    
    .table td, .table th {
        padding: 0.75rem 0.5rem;
    }
}
</style>
@endpush

@push('js')
<script>
let connectionToDelete = null;

function toggleConnectionStatus(button) {
    const connectionId = button.getAttribute('data-connection-id');
    const originalContent = button.innerHTML;
    button.disabled = true;
    button.innerHTML = '<i class="fas fa-spinner fa-spin"></i>';
    
    const url = '{{ route("contacts.crm.toggle-status", ["crmConnection" => "PLACEHOLDER"]) }}'.replace('PLACEHOLDER', connectionId);
    
    fetch(url, {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': '{{ csrf_token() }}',
            'Content-Type': 'application/json',
        },
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            button.innerHTML = '<i class="fas fa-check"></i>';
            button.classList.remove('btn-outline-warning', 'btn-outline-success');
            button.classList.add('btn-success');
            setTimeout(() => { 
                location.reload(); 
            }, 1000);
        } else {
            button.innerHTML = '<i class="fas fa-times"></i>';
            button.classList.add('btn-danger');
            alert(data.message || '{{ __("crm.status_toggle_failed") }}');
            setTimeout(() => { 
                button.innerHTML = originalContent; 
                button.disabled = false; 
                button.classList.remove('btn-danger'); 
            }, 2000);
        }
    })
    .catch(error => {
        console.error('Error:', error);
        button.innerHTML = '<i class="fas fa-times"></i>';
        button.classList.add('btn-danger');
        alert('{{ __("crm.status_toggle_failed") }}');
        setTimeout(() => { 
            button.innerHTML = originalContent; 
            button.disabled = false; 
            button.classList.remove('btn-danger'); 
        }, 2000);
    });
}

function deleteConnection(button) {
    const connectionId = button.getAttribute('data-connection-id');
    connectionToDelete = connectionId;
    $('#deleteModal').modal('show');
}

$('#confirmDelete').click(function() {
    if (connectionToDelete) {
        const url = '{{ route("contacts.crm.destroy", ["crmConnection" => "PLACEHOLDER"]) }}'.replace('PLACEHOLDER', connectionToDelete);
        
        fetch(url, {
            method: 'DELETE',
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}',
                'Content-Type': 'application/json',
                'Accept': 'application/json',
            },
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            } else {
                alert(data.message || '{{ __("crm.delete_failed") }}');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('{{ __("crm.delete_failed") }}');
        });
    }
    $('#deleteModal').modal('hide');
});

// Initialize DataTable if needed
$(document).ready(function() {
    if ($.fn.DataTable) {
        $('#connectionsTable').DataTable({
            "pageLength": 10,
            "order": [[ 4, "desc" ]],
            "language": {
                "search": "{{ __('crm.search') }}:",
                "lengthMenu": "{{ __('crm.show') }} _MENU_ {{ __('crm.entries') }}",
                "info": "{{ __('crm.showing') }} _START_ {{ __('crm.to') }} _END_ {{ __('crm.of') }} _TOTAL_ {{ __('crm.entries') }}",
                "paginate": {
                    "first": "{{ __('crm.first') }}",
                    "last": "{{ __('crm.last') }}",
                    "next": "{{ __('crm.next') }}",
                    "previous": "{{ __('crm.previous') }}"
                }
            }
        });
    }
});
</script>
@endpush