@extends('layouts.app', ['title' => __('crm.credentials_guide')])

@section('content')
<div class="header pb-8 pt-5 pt-md-8">
    <div class="container-fluid">
        <div class="header-body">
            <div class="row align-items-center py-4">
                <div class="col-lg-6 col-7">
                    <nav aria-label="breadcrumb" class="d-none d-md-inline-block ml-md-4">
                        <ol class="breadcrumb breadcrumb-links breadcrumb-dark">
                            <li class="breadcrumb-item"><a href="{{ route('contacts.crm-dashboard.index') }}"><i class="fas fa-home"></i></a></li>
                            <li class="breadcrumb-item"><a href="{{ route('contacts.crm-dashboard.index') }}">{{ __('crm.crm_dashboard') }}</a></li>
                            <li class="breadcrumb-item active" aria-current="page">{{ __('crm.credentials_guide') }}</li>
                        </ol>
                    </nav>
                </div>
                <div class="col-lg-6 col-5 text-right">
                    <a href="{{ route('contacts.crm-dashboard.index') }}" class="btn btn-sm btn-neutral">
                        <i class="fas fa-arrow-left mr-2"></i>{{ __('crm.back_to_dashboard') }}
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="container-fluid mt--7">
    <div class="row">
        <div class="col-12">
            <div class="card shadow">
                <div class="card-header bg-white border-0">
                    <div class="row align-items-center">
                        <div class="col-8">
                            <h3 class="mb-0 text-primary">
                                <i class="fas fa-key mr-2"></i>{{ __('crm.credentials_guide') }}
                            </h3>
                            <p class="text-muted mt-2">{{ __('crm.credentials_guide_description') }}</p>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <!-- HubSpot Guide -->
                    <div class="mb-5">
                        <div class="d-flex align-items-center mb-4">
                            <div class="bg-orange rounded-circle d-flex align-items-center justify-content-center mr-3" style="width: 50px; height: 50px;">
                                <i class="fab fa-hubspot text-white fa-lg"></i>
                            </div>
                            <div>
                                <h4 class="mb-0 text-dark">{{ __('crm.hubspot_credentials') }}</h4>
                                <p class="text-muted mb-0">{{ __('crm.hubspot_credentials_description') }}</p>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-lg-8">
                                <div class="step-by-step-guide">
                                    <div class="step mb-4">
                                        <div class="step-number">1</div>
                                        <div class="step-content">
                                            <h5 class="font-weight-bold">{{ __('crm.step_1_title') }}</h5>
                                            <p class="mb-2">{{ __('crm.step_1_description') }}</p>
                                            <div class="alert alert-info">
                                                <i class="fas fa-info-circle mr-2"></i>
                                                <strong>{{ __('crm.note') }}:</strong> {{ __('crm.hubspot_note') }}
                                            </div>
                                        </div>
                                    </div>

                                    <div class="step mb-4">
                                        <div class="step-number">2</div>
                                        <div class="step-content">
                                            <h5 class="font-weight-bold">{{ __('crm.step_2_title') }}</h5>
                                            <p class="mb-2">{{ __('crm.step_2_description') }}</p>
                                            <div class="code-block">
                                                <code>{{ __('crm.hubspot_url') }}</code>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="step mb-4">
                                        <div class="step-number">3</div>
                                        <div class="step-content">
                                            <h5 class="font-weight-bold">{{ __('crm.step_3_title') }}</h5>
                                            <p class="mb-2">{{ __('crm.step_3_description') }}</p>
                                            <ul class="list-unstyled">
                                                <li><i class="fas fa-check text-success mr-2"></i>{{ __('crm.hubspot_permission_1') }}</li>
                                                <li><i class="fas fa-check text-success mr-2"></i>{{ __('crm.hubspot_permission_2') }}</li>
                                                <li><i class="fas fa-check text-success mr-2"></i>{{ __('crm.hubspot_permission_3') }}</li>
                                            </ul>
                                        </div>
                                    </div>

                                    <div class="step mb-4">
                                        <div class="step-number">4</div>
                                        <div class="step-content">
                                            <h5 class="font-weight-bold">{{ __('crm.step_4_title') }}</h5>
                                            <p class="mb-2">{{ __('crm.step_4_description') }}</p>
                                            <div class="alert alert-warning">
                                                <i class="fas fa-exclamation-triangle mr-2"></i>
                                                <strong>{{ __('crm.important') }}:</strong> {{ __('crm.hubspot_token_warning') }}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="card bg-light">
                                    <div class="card-body">
                                        <h6 class="font-weight-bold text-primary mb-3">
                                            <i class="fas fa-lightbulb mr-2"></i>{{ __('crm.quick_tips') }}
                                        </h6>
                                        <ul class="list-unstyled mb-0">
                                            <li class="mb-2">
                                                <i class="fas fa-dot-circle text-primary mr-2"></i>
                                                {{ __('crm.tip_1') }}
                                            </li>
                                            <li class="mb-2">
                                                <i class="fas fa-dot-circle text-primary mr-2"></i>
                                                {{ __('crm.tip_2') }}
                                            </li>
                                            <li class="mb-2">
                                                <i class="fas fa-dot-circle text-primary mr-2"></i>
                                                {{ __('crm.tip_3') }}
                                            </li>
                                            <li class="mb-0">
                                                <i class="fas fa-dot-circle text-primary mr-2"></i>
                                                {{ __('crm.tip_4') }}
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <hr class="my-5">

                    <!-- Odoo Guide -->
                    <div class="mb-5">
                        <div class="d-flex align-items-center mb-4">
                            <div class="bg-info rounded-circle d-flex align-items-center justify-content-center mr-3" style="width: 50px; height: 50px;">
                                <i class="fas fa-database text-white fa-lg"></i>
                            </div>
                            <div>
                                <h4 class="mb-0 text-dark">{{ __('crm.odoo_credentials') }}</h4>
                                <p class="text-muted mb-0">{{ __('crm.odoo_credentials_description') }}</p>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-lg-8">
                                <div class="step-by-step-guide">
                                    <div class="step mb-4">
                                        <div class="step-number">1</div>
                                        <div class="step-content">
                                            <h5 class="font-weight-bold">{{ __('crm.odoo_step_1_title') }}</h5>
                                            <p class="mb-2">{{ __('crm.odoo_step_1_description') }}</p>
                                            <div class="code-block">
                                                <code>{{ __('crm.odoo_url') }}</code>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="step mb-4">
                                        <div class="step-number">2</div>
                                        <div class="step-content">
                                            <h5 class="font-weight-bold">{{ __('crm.odoo_step_2_title') }}</h5>
                                            <p class="mb-2">{{ __('crm.odoo_step_2_description') }}</p>
                                            <div class="alert alert-info">
                                                <i class="fas fa-info-circle mr-2"></i>
                                                <strong>{{ __('crm.note') }}:</strong> {{ __('crm.odoo_note') }}
                                            </div>
                                        </div>
                                    </div>

                                    <div class="step mb-4">
                                        <div class="step-number">3</div>
                                        <div class="step-content">
                                            <h5 class="font-weight-bold">{{ __('crm.odoo_step_3_title') }}</h5>
                                            <p class="mb-2">{{ __('crm.odoo_step_3_description') }}</p>
                                            <ul class="list-unstyled">
                                                <li><i class="fas fa-check text-success mr-2"></i>{{ __('crm.odoo_credential_1') }}</li>
                                                <li><i class="fas fa-check text-success mr-2"></i>{{ __('crm.odoo_credential_2') }}</li>
                                                <li><i class="fas fa-check text-success mr-2"></i>{{ __('crm.odoo_credential_3') }}</li>
                                                <li><i class="fas fa-check text-success mr-2"></i>{{ __('crm.odoo_credential_4') }}</li>
                                            </ul>
                                        </div>
                                    </div>

                                    <div class="step mb-4">
                                        <div class="step-number">4</div>
                                        <div class="step-content">
                                            <h5 class="font-weight-bold">{{ __('crm.odoo_step_4_title') }}</h5>
                                            <p class="mb-2">{{ __('crm.odoo_step_4_description') }}</p>
                                            <div class="alert alert-warning">
                                                <i class="fas fa-exclamation-triangle mr-2"></i>
                                                <strong>{{ __('crm.important') }}:</strong> {{ __('crm.odoo_warning') }}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="card bg-light">
                                    <div class="card-body">
                                        <h6 class="font-weight-bold text-primary mb-3">
                                            <i class="fas fa-lightbulb mr-2"></i>{{ __('crm.odoo_quick_tips') }}
                                        </h6>
                                        <ul class="list-unstyled mb-0">
                                            <li class="mb-2">
                                                <i class="fas fa-dot-circle text-primary mr-2"></i>
                                                {{ __('crm.odoo_tip_1') }}
                                            </li>
                                            <li class="mb-2">
                                                <i class="fas fa-dot-circle text-primary mr-2"></i>
                                                {{ __('crm.odoo_tip_2') }}
                                            </li>
                                            <li class="mb-2">
                                                <i class="fas fa-dot-circle text-primary mr-2"></i>
                                                {{ __('crm.odoo_tip_3') }}
                                            </li>
                                            <li class="mb-0">
                                                <i class="fas fa-dot-circle text-primary mr-2"></i>
                                                {{ __('crm.odoo_tip_4') }}
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Support Section -->
                    <div class="card bg-gradient-primary text-white">
                        <div class="card-body text-center">
                            <h4 class="text-white mb-3">
                                <i class="fas fa-question-circle mr-2"></i>{{ __('crm.need_help') }}
                            </h4>
                            <p class="text-white-50 mb-4">{{ __('crm.support_description') }}</p>
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <a href="{{ route('contacts.crm.create') }}" class="btn btn-light btn-lg btn-block">
                                        <i class="fas fa-plus mr-2"></i>{{ __('crm.create_connection') }}
                                    </a>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <a href="mailto:support@yourcompany.com" class="btn btn-outline-light btn-lg btn-block">
                                        <i class="fas fa-envelope mr-2"></i>{{ __('crm.contact_support') }}
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('css')
<style>
.step-by-step-guide {
    position: relative;
}

.step {
    display: flex;
    align-items: flex-start;
    position: relative;
}

.step-number {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    width: 40px;
    height: 40px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: bold;
    font-size: 18px;
    margin-right: 20px;
    flex-shrink: 0;
    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
}

.step-content {
    flex: 1;
    padding-top: 5px;
}

.step-content h5 {
    color: #2d3748;
    margin-bottom: 8px;
}

.step-content p {
    color: #4a5568;
    line-height: 1.6;
}

.code-block {
    background: #f7fafc;
    border: 1px solid #e2e8f0;
    border-radius: 6px;
    padding: 12px 16px;
    margin: 10px 0;
}

.code-block code {
    color: #2d3748;
    font-family: 'Monaco', 'Menlo', 'Ubuntu Mono', monospace;
    font-size: 14px;
    background: none;
    padding: 0;
}

.alert {
    border-radius: 8px;
    border: none;
    box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
}

.alert-info {
    background: linear-gradient(135deg, #e6f3ff 0%, #cce7ff 100%);
    color: #1a365d;
}

.alert-warning {
    background: linear-gradient(135deg, #fff5e6 0%, #ffe6cc 100%);
    color: #7c2d12;
}

.card.bg-light {
    border: 1px solid #e2e8f0;
    box-shadow: 0 2px 4px rgba(0, 0, 0, 0.05);
}

.card.bg-light .card-body {
    padding: 1.5rem;
}

.list-unstyled li {
    padding: 4px 0;
    color: #4a5568;
}

.bg-gradient-primary {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border: none;
    box-shadow: 0 8px 16px rgba(0, 0, 0, 0.1);
}

@media (max-width: 768px) {
    .step {
        flex-direction: column;
        text-align: center;
    }
    
    .step-number {
        margin-right: 0;
        margin-bottom: 15px;
    }
    
    .step-content {
        padding-top: 0;
    }
}
</style>
@endpush