@extends('layouts.app', ['title' => __('crm.import_details_title')])

@section('content')
<div class="header pb-8 pt-5 pt-md-8">
    <div class="container-fluid">
        <div class="header-body">
            <div class="row align-items-center py-4">
                <div class="col-lg-6 col-7">
                    <nav aria-label="breadcrumb" class="d-none d-md-inline-block ml-md-4">
                        <ol class="breadcrumb breadcrumb-links breadcrumb-dark">
                            <li class="breadcrumb-item"><a href="{{ route('contacts.index') }}"><i class="fas fa-home"></i></a></li>
                            <li class="breadcrumb-item"><a href="{{ route('contacts.index') }}">{{ __('Contacts') }}</a></li>
                            <li class="breadcrumb-item"><a href="{{ route('contacts.crm-import.history') }}">{{ __('crm.import_history_title') }}</a></li>
                            <li class="breadcrumb-item active" aria-current="page">{{ __('crm.import_details_title') }}</li>
                        </ol>
                    </nav>
                </div>
                <div class="col-lg-6 col-5 text-right">
                    <a href="{{ route('contacts.crm-import.history') }}" class="btn btn-sm btn-neutral">
                        <i class="fas fa-arrow-left mr-2"></i>{{ __('crm.back_to_history') }}
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="container-fluid mt--7">
    <div class="row">
        <div class="col">
            <div class="card shadow">
                <div class="card-header border-0">
                    <div class="row align-items-center">
                        <div class="col">
                            <h3 class="mb-0">
                                <i class="fas fa-info-circle text-info mr-2"></i>
                                {{ __('crm.import_details_title') }}
                            </h3>
                            <p class="text-muted mb-0">{{ __('crm.import_details_subtitle') }}</p>
                        </div>
                    </div>
                </div>

                <div class="card-body">
                    <!-- Import Overview -->
                    <div class="row mb-4">
                        <div class="col-md-6">
                            <h5 class="text-primary">{{ __('crm.import_overview') }}</h5>
                            <table class="table table-sm">
                                <tr>
                                    <td><strong>{{ __('crm.connection_name') }}:</strong></td>
                                    <td>{{ $syncHistory->crmConnection->name ?? 'Deleted Connection' }}</td>
                                </tr>
                                <tr>
                                    <td><strong>{{ __('crm.crm_type') }}:</strong></td>
                                    <td>{{ $syncHistory->crmConnection->type_display ?? 'Unknown' }}</td>
                                </tr>
                                <tr>
                                    <td><strong>{{ __('crm.sync_type') }}:</strong></td>
                                    <td><span class="badge badge-info">{{ $syncHistory->sync_type_display }}</span></td>
                                </tr>
                                <tr>
                                    <td><strong>{{ __('crm.status') }}:</strong></td>
                                    <td>
                                        @switch($syncHistory->status)
                                            @case('completed')
                                                <span class="badge badge-success">
                                                    <i class="fas fa-check-circle"></i> {{ $syncHistory->status_display }}
                                                </span>
                                                @break
                                            @case('in_progress')
                                                <span class="badge badge-warning">
                                                    <i class="fas fa-spinner fa-spin"></i> {{ $syncHistory->status_display }}
                                                </span>
                                                @break
                                            @case('failed')
                                                <span class="badge badge-danger">
                                                    <i class="fas fa-times-circle"></i> {{ $syncHistory->status_display }}
                                                </span>
                                                @break
                                            @case('cancelled')
                                                <span class="badge badge-secondary">
                                                    <i class="fas fa-ban"></i> {{ $syncHistory->status_display }}
                                                </span>
                                                @break
                                            @default
                                                <span class="badge badge-light">{{ $syncHistory->status_display }}</span>
                                        @endswitch
                                    </td>
                                </tr>
                            </table>
                        </div>
                        <div class="col-md-6">
                            <h5 class="text-primary">{{ __('crm.timing_information') }}</h5>
                            <table class="table table-sm">
                                <tr>
                                    <td><strong>{{ __('crm.started_at') }}:</strong></td>
                                    <td>
                                        @if($syncHistory->started_at)
                                            {{ $syncHistory->started_at->format('M j, Y H:i:s') }}
                                            <br><small class="text-muted">{{ $syncHistory->started_at->diffForHumans() }}</small>
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <td><strong>{{ __('crm.completed_at') }}:</strong></td>
                                    <td>
                                        @if($syncHistory->completed_at)
                                            {{ $syncHistory->completed_at->format('M j, Y H:i:s') }}
                                            <br><small class="text-muted">{{ $syncHistory->completed_at->diffForHumans() }}</small>
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <td><strong>{{ __('crm.duration') }}:</strong></td>
                                    <td>
                                        @if($syncHistory->duration_human)
                                            {{ $syncHistory->duration_human }}
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                </tr>
                            </table>
                        </div>
                    </div>

                    <!-- Statistics -->
                    <div class="row mb-4">
                        <div class="col">
                            <h5 class="text-primary">{{ __('crm.import_statistics') }}</h5>
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="card border-left-primary shadow h-100 py-2">
                                        <div class="card-body">
                                            <div class="row no-gutters align-items-center">
                                                <div class="col mr-2">
                                                    <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">{{ __('crm.total_records') }}</div>
                                                    <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $syncHistory->total_records ?? 0 }}</div>
                                                </div>
                                                <div class="col-auto">
                                                    <i class="fas fa-database fa-2x text-gray-300"></i>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="card border-left-success shadow h-100 py-2">
                                        <div class="card-body">
                                            <div class="row no-gutters align-items-center">
                                                <div class="col mr-2">
                                                    <div class="text-xs font-weight-bold text-success text-uppercase mb-1">{{ __('crm.successful_records') }}</div>
                                                    <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $syncHistory->successful_records ?? 0 }}</div>
                                                </div>
                                                <div class="col-auto">
                                                    <i class="fas fa-check fa-2x text-gray-300"></i>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="card border-left-warning shadow h-100 py-2">
                                        <div class="card-body">
                                            <div class="row no-gutters align-items-center">
                                                <div class="col mr-2">
                                                    <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">{{ __('crm.duplicate_records') }}</div>
                                                    <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $syncHistory->duplicate_records ?? 0 }}</div>
                                                </div>
                                                <div class="col-auto">
                                                    <i class="fas fa-copy fa-2x text-gray-300"></i>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="card border-left-danger shadow h-100 py-2">
                                        <div class="card-body">
                                            <div class="row no-gutters align-items-center">
                                                <div class="col mr-2">
                                                    <div class="text-xs font-weight-bold text-danger text-uppercase mb-1">{{ __('crm.failed_records') }}</div>
                                                    <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $syncHistory->failed_records ?? 0 }}</div>
                                                </div>
                                                <div class="col-auto">
                                                    <i class="fas fa-times fa-2x text-gray-300"></i>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Progress Bar -->
                    @if($syncHistory->total_records > 0)
                    <div class="row mb-4">
                        <div class="col">
                            <h5 class="text-primary">{{ __('crm.progress') }}</h5>
                            <div class="progress">
                                @php
                                    $progressPercentage = ($syncHistory->processed_records / $syncHistory->total_records) * 100;
                                @endphp
                                <div class="progress-bar bg-primary" role="progressbar" 
                                     style="width: {{ $progressPercentage }}%" 
                                     aria-valuenow="{{ $progressPercentage }}" 
                                     aria-valuemin="0" 
                                     aria-valuemax="100">
                                    {{ number_format($progressPercentage, 1) }}%
                                </div>
                            </div>
                            <small class="text-muted">
                                {{ $syncHistory->processed_records }} / {{ $syncHistory->total_records }} {{ __('crm.records_processed') }}
                            </small>
                        </div>
                    </div>
                    @endif

                    <!-- Error Message -->
                    @if($syncHistory->error_message)
                    <div class="row mb-4">
                        <div class="col">
                            <h5 class="text-danger">{{ __('crm.error_details') }}</h5>
                            <div class="alert alert-danger">
                                <i class="fas fa-exclamation-triangle mr-2"></i>
                                {{ $syncHistory->error_message }}
                            </div>
                        </div>
                    </div>
                    @endif

                    <!-- Additional Data -->
                    @if($syncHistory->additional_data)
                    <div class="row mb-4">
                        <div class="col">
                            <h5 class="text-primary">{{ __('crm.additional_information') }}</h5>
                            <div class="card">
                                <div class="card-body">
                                    <pre class="mb-0">{{ json_encode(json_decode($syncHistory->additional_data), JSON_PRETTY_PRINT) }}</pre>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection