@extends('layouts.app', ['title' => __('crm.crm_import_title')])

@section('content')
<div class="header pb-8 pt-5 pt-md-8">
</div>
<div class="container-fluid mt--7">
    <div class="row">
        <div class="col">
            <div class="card shadow">
                <div class="card-header border-0">
                    <div class="row align-items-center">
                        <div class="col-8">
                            <h3 class="mb-0">{{ __('crm.crm_import_title') }}</h3>
                        </div>
                        <div class="col-4 text-right">
                            <a href="{{ route('contacts.crm-dashboard.index') }}" class="btn btn-sm btn-secondary">
                                <i class="ni ni-bold-left"></i> {{ __('crm.back_to_import') }}
                            </a>
                        </div>
                    </div>
                </div>

                <div class="col-12">
                    @include('partials.flash')
                </div>

                <div class="card-body">
                    @if($crmConnections->isEmpty())
                    <div class="text-center py-5">
                        <i class="fas fa-plug fa-3x text-muted mb-3"></i>
                        <h4>{{ __('crm.no_crm_connections') }}</h4>
                        <p class="text-muted">{{ __('crm.create_crm_connection_first') }}</p>
                        <a href="{{ route('contacts.crm.create') }}" class="btn btn-primary">
                            <i class="ni ni-fat-add"></i> {{ __('crm.create_connection') }}
                        </a>
                    </div>
                    @else
                    <!-- Success Messages -->
                    @if(session('status'))
                    @if(str_contains(session('status'), 'created'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <i class="fas fa-check-circle"></i>
                        <strong>{{ __('crm.connection_created') }}!</strong> {{ session('status') }}
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    @elseif(str_contains(session('status'), 'imported'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <i class="fas fa-check-circle"></i>
                        <strong>{{ __('crm.import_success') }}</strong> {{ session('status') }}
                        <div class="mt-2">
                            <a href="{{ route('contacts.index') }}" class="btn btn-sm btn-success">
                                <i class="fas fa-eye"></i> {{ __('crm.view_imported_contacts') }}
                            </a>
                            <a href="{{ route('contacts.import-history') }}" class="btn btn-sm btn-info">
                                <i class="fas fa-history"></i> {{ __('crm.import_history') }}
                            </a>
                        </div>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    @endif
                    @endif

                    <!-- Import Instructions -->
                    <div class="alert alert-info">
                        <h5><i class="fas fa-info-circle"></i> {{ __('crm.import_instructions_title') }}</h5>
                        <ol class="mb-0">
                            <li>{{ __('crm.import_step_1') }}</li>
                            <li>{{ __('crm.import_step_2') }}</li>
                            <li>{{ __('crm.import_step_3') }}</li>
                            <li>{{ __('crm.import_step_4') }}</li>
                        </ol>
                    </div>
                    <form id="crmImportForm">
                        @csrf

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="crm_connection_id" class="form-control-label">
                                        {{ __('crm.select_connection') }} *
                                    </label>
                                    <select name="crm_connection_id"
                                        id="crm_connection_id"
                                        class="form-control @error('crm_connection_id') is-invalid @enderror"
                                        required>
                                        <option value="">{{ __('crm.choose_connection') }}</option>
                                        @foreach($crmConnections as $connection)
                                        <option value="{{ $connection->id }}"
                                            data-type="{{ $connection->type }}"
                                            {{ (old('crm_connection_id') == $connection->id || (isset($selectedConnection) && $selectedConnection && $selectedConnection->id == $connection->id)) ? 'selected' : '' }}>
                                            {{ $connection->name }} ({{ $connection->type_display }})
                                            @if($connection->is_healthy)
                                            <span class="text-success">✓</span>
                                            @else
                                            <span class="text-danger">✗</span>
                                            @endif
                                        </option>
                                        @endforeach
                                    </select>
                                    @error('crm_connection_id')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="duplicate_strategy" class="form-control-label">
                                        {{ __('crm.duplicate_strategy') }} *
                                    </label>
                                    <select name="duplicate_strategy"
                                        id="duplicate_strategy"
                                        class="form-control @error('duplicate_strategy') is-invalid @enderror"
                                        required>
                                        <option value="skip" {{ old('duplicate_strategy') == 'skip' ? 'selected' : '' }}>
                                            {{ __('crm.skip_duplicates') }} - {{ __('crm.skip_duplicates_desc') }}
                                        </option>
                                        <option value="update" {{ old('duplicate_strategy') == 'update' ? 'selected' : '' }}>
                                            {{ __('crm.update_existing') }} - {{ __('crm.update_existing_desc') }}
                                        </option>
                                        <option value="merge" {{ old('duplicate_strategy') == 'merge' ? 'selected' : '' }}>
                                            {{ __('crm.merge_data') }} - {{ __('crm.merge_data_desc') }}
                                        </option>
                                    </select>
                                    <small class="form-text text-muted">{{ __('crm.duplicate_strategy_help') }}</small>
                                    @error('duplicate_strategy')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-4" id="contact_type_group" style="display: none;">
                                <div class="form-group">
                                    <label for="contact_type" class="form-control-label">
                                        {{ __('crm.contact_type') }}
                                    </label>
                                    <select name="contact_type"
                                        id="contact_type"
                                        class="form-control @error('contact_type') is-invalid @enderror">
                                        <option value="both" {{ old('contact_type', 'both') == 'both' ? 'selected' : '' }}>
                                            {{ __('crm.both_individual_and_company') }}
                                        </option>
                                        <option value="individual" {{ old('contact_type') == 'individual' ? 'selected' : '' }}>
                                            {{ __('crm.individual_contacts_only') }}
                                        </option>
                                        <option value="company" {{ old('contact_type') == 'company' ? 'selected' : '' }}>
                                            {{ __('crm.company_contacts_only') }}
                                        </option>
                                    </select>
                                    <small class="form-text text-muted">{{ __('crm.contact_type_help') }}</small>
                                    @error('contact_type')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="batch_size" class="form-control-label">
                                        {{ __('crm.batch_size') }}
                                    </label>
                                    <input type="number"
                                        name="batch_size"
                                        id="batch_size"
                                        class="form-control @error('batch_size') is-invalid @enderror"
                                        value="{{ old('batch_size', 100) }}"
                                        min="1"
                                        max="1000">
                                    <small class="form-text text-muted">{{ __('crm.batch_size_help_text') }}</small>
                                    @error('batch_size')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="assign_to_group" class="form-control-label">
                                        {{ __('crm.assign_to_group') }}
                                    </label>
                                    <select name="assign_to_group"
                                        id="assign_to_group"
                                        class="form-control @error('assign_to_group') is-invalid @enderror">
                                        <option value="">{{ __('crm.no_group') }}</option>
                                        @foreach($groups as $id => $name)
                                        <option value="{{ $id }}" {{ old('assign_to_group') == $id ? 'selected' : '' }}>
                                            {{ $name }}
                                        </option>
                                        @endforeach
                                    </select>
                                    @error('assign_to_group')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <!-- Import Settings -->
                        <div class="row">
                            <div class="col-md-12">
                                <h5>{{ __('crm.import_settings') }}</h5>
                                <div class="form-group">
                                    <div class="custom-control custom-checkbox">
                                        <input type="checkbox"
                                            name="import_settings[auto_assign_country]"
                                            id="auto_assign_country"
                                            class="custom-control-input"
                                            value="1"
                                            {{ old('import_settings.auto_assign_country', true) ? 'checked' : '' }}>
                                        <label class="custom-control-label" for="auto_assign_country">
                                            {{ __('crm.auto_assign_country') }}
                                        </label>
                                        <small class="form-text text-muted">{{ __('crm.auto_assign_country_help') }}</small>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="custom-control custom-checkbox">
                                        <input type="checkbox"
                                            name="import_settings[create_missing_groups]"
                                            id="create_missing_groups"
                                            class="custom-control-input"
                                            value="1"
                                            {{ old('import_settings.create_missing_groups') ? 'checked' : '' }}>
                                        <label class="custom-control-label" for="create_missing_groups">
                                            {{ __('crm.create_missing_groups') }}
                                        </label>
                                        <small class="form-text text-muted">{{ __('crm.create_missing_groups_help') }}</small>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="form-group mt-4">
                            <button type="submit"
                                id="startImportBtn"
                                class="btn btn-primary">
                                <i class="ni ni-cloud-download-95"></i> {{ __('crm.start_import') }}
                            </button>
                            <a href="{{ route('contacts.crm-dashboard.index') }}" class="btn btn-secondary">
                                {{ __('crm.cancel') }}
                            </a>
                        </div>
                    </form>

                    <!-- Import Progress Modal -->
                    <div class="modal fade" id="importProgressModal" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title">{{ __('crm.import_progress') }}</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <div id="progressContainer">
                                        <div class="progress mb-3">
                                            <div id="progressBar" class="progress-bar" role="progressbar" style="width: 0%"></div>
                                        </div>

                                        <div class="row">
                                            <div class="col-md-3">
                                                <div class="text-center">
                                                    <h4 id="processedCount">0</h4>
                                                    <small class="text-muted">{{ __('crm.processed') }}</small>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="text-center">
                                                    <h4 id="importedCount" class="text-success">0</h4>
                                                    <small class="text-muted">{{ __('crm.imported') }}</small>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="text-center">
                                                    <h4 id="duplicateCount" class="text-warning">0</h4>
                                                    <small class="text-muted">{{ __('crm.duplicates') }}</small>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="text-center">
                                                    <h4 id="failedCount" class="text-danger">0</h4>
                                                    <small class="text-muted">{{ __('crm.failed') }}</small>
                                                </div>
                                            </div>
                                        </div>

                                        <div id="importStatus" class="mt-3">
                                            <div class="alert alert-info">
                                                <i class="fas fa-spinner fa-spin"></i> {{ __('crm.import_starting') }}
                                            </div>
                                        </div>
                                    </div>

                                    <div class="modal-footer">
                                        <button type="button"
                                            id="cancelImportBtn"
                                            class="btn btn-danger"
                                            style="display: none;">
                                            <i class="fas fa-stop"></i> {{ __('crm.cancel_import') }}
                                        </button>
                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">
                                            {{ __('crm.close') }}
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @endif

            @include('layouts.footers.auth')
        </div>
        @endsection

        @push('js')
        <script>
            // Pass route URLs to JavaScript
            window.crmRoutes = {
                importStore: '{{ route("contacts.crm-import.store") }}',
                importProgress: '{{ route("contacts.crm-import.progress") }}',
                importCancel: '{{ route("contacts.crm-import.cancel") }}',
                importHistory: '{{ route("contacts.crm-import.history") }}'
            };

            // Show/hide contact type field based on CRM connection type
            document.addEventListener('DOMContentLoaded', function() {
                const crmConnectionSelect = document.getElementById('crm_connection_id');
                const contactTypeGroup = document.getElementById('contact_type_group');

                function toggleContactTypeField() {
                    if (crmConnectionSelect.value) {
                        const selectedOption = crmConnectionSelect.options[crmConnectionSelect.selectedIndex];
                        const crmType = selectedOption.getAttribute('data-type');

                        if (crmType === 'odoo') {
                            contactTypeGroup.style.display = 'block';
                        } else {
                            contactTypeGroup.style.display = 'none';
                            // Reset contact type to default when hiding
                            document.getElementById('contact_type').value = 'both';
                        }
                    } else {
                        contactTypeGroup.style.display = 'none';
                    }
                }

                // Initial check
                toggleContactTypeField();

                // Listen for changes
                crmConnectionSelect.addEventListener('change', toggleContactTypeField);
            });
        </script>
        <script src="{{ asset('js/contacts/crm-integration.js') }}"></script>
        @endpush