<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCrmSyncHistoryTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('crm_sync_history', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('company_id');
            $table->unsignedBigInteger('crm_connection_id');
            $table->string('sync_type'); // import, export, sync
            $table->string('status'); // pending, in_progress, completed, failed, cancelled
            $table->integer('total_records')->default(0);
            $table->integer('processed_records')->default(0);
            $table->integer('successful_records')->default(0);
            $table->integer('failed_records')->default(0);
            $table->integer('duplicate_records')->default(0);
            $table->json('import_settings')->nullable(); // Store import configuration
            $table->json('field_mapping')->nullable(); // Field mapping used
            $table->text('error_message')->nullable();
            $table->timestamp('started_at')->nullable();
            $table->timestamp('completed_at')->nullable();
            $table->timestamps();
            $table->softDeletes();

            // Foreign key constraints
            $table->foreign('company_id')->references('id')->on('companies')->onDelete('cascade');
            $table->foreign('crm_connection_id')->references('id')->on('crm_connections')->onDelete('cascade');
            
            // Indexes
            $table->index(['company_id', 'crm_connection_id']);
            $table->index(['company_id', 'status']);
            $table->index('sync_type');
            $table->index('started_at');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('crm_sync_history');
    }
}