@extends('layouts.app', ['title' => __('crm.connections_title')])

@section('content')
    <div class="header pb-8 pt-5 pt-md-8">
    </div>
    <div class="container-fluid mt--7">
        <div class="row">
            <div class="col">
                <div class="card shadow">
                    <div class="card-header border-0">
                        <div class="row align-items-center">
                            <div class="col-8">
                                <h3 class="mb-0">{{ __('crm.connections_title') }}</h3>
                            </div>
                            <div class="col-4 text-right">
                                <a href="{{ route('contacts.crm-import.index') }}" class="btn btn-sm btn-success mr-2">
                                    <i class="fas fa-download"></i> {{ __('crm.import_contacts') }}
                                </a>
                                <a href="{{ route('contacts.crm.create') }}" class="btn btn-sm btn-primary">
                                    <i class="fas fa-plus"></i> {{ __('crm.add_connection') }}
                                </a>
                            </div>
                        </div>
                    </div>

                    <div class="col-12">
                        @include('partials.flash')
                    </div>

                    <div class="table-responsive">
                        <table class="table align-items-center table-flush">
                            <thead class="thead-light">
                                <tr>
                                    <th scope="col">{{ __('crm.name') }}</th>
                                    <th scope="col">{{ __('crm.type') }}</th>
                                    <th scope="col">{{ __('crm.status') }}</th>
                                    <th scope="col">{{ __('crm.last_sync') }}</th>
                                    <th scope="col">{{ __('crm.health') }}</th>
                                    <th scope="col">{{ __('crm.actions') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($connections as $connection)
                                    <tr>
                                        <td>
                                            <div class="media align-items-center">
                                                <div class="media-body">
                                                    <span class="name mb-0 text-sm">{{ $connection->name }}</span>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <span class="badge badge-info">{{ $connection->type_display }}</span>
                                        </td>
                                        <td>
                                            @if($connection->is_active)
                                                <span class="badge badge-success">{{ __('crm.active') }}</span>
                                            @else
                                                <span class="badge badge-secondary">{{ __('crm.inactive') }}</span>
                                            @endif
                                        </td>
                                        <td>
                                            @if($connection->last_sync_at)
                                                {{ $connection->last_sync_at->diffForHumans() }}
                                            @else
                                                <span class="text-muted">{{ __('crm.never') }}</span>
                                            @endif
                                        </td>
                                        <td>
                                            @if($connection->is_healthy)
                                                <span class="badge badge-success">
                                                    <i class="fas fa-check-circle"></i> {{ __('crm.healthy') }}
                                                </span>
                                            @else
                                                <span class="badge badge-danger">
                                                    <i class="fas fa-exclamation-circle"></i> {{ __('crm.unhealthy') }}
                                                </span>
                                            @endif
                                        </td>
                                        <td>
                                            <div class="btn-group btn-group-sm" role="group" style="gap: 2px;">
                                                <a href="{{ route('contacts.crm.show', $connection) }}" 
                                                   class="btn btn-sm btn-outline-primary"
                                                   title="{{ __('crm.view_connection') }}">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <a href="{{ route('contacts.crm.edit', $connection) }}" 
                                                   class="btn btn-sm btn-outline-secondary"
                                                   title="{{ __('crm.edit_connection') }}">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                @if($connection->is_healthy)
                                                    <a href="{{ route('contacts.crm-import.index') }}?connection={{ $connection->id }}" 
                                                       class="btn btn-sm btn-outline-success"
                                                       title="{{ __('crm.import_contacts') }}">
                                                        <i class="fas fa-download"></i>
                                                    </a>
                                                @endif
                                                <button type="button" 
                                                        class="btn btn-sm btn-outline-{{ $connection->is_active ? 'warning' : 'success' }}"
                                                        onclick="toggleConnectionStatus({{ $connection->id }})"
                                                        title="{{ $connection->is_active ? __('crm.deactivate') : __('crm.activate') }}">
                                                    <i class="fas fa-{{ $connection->is_active ? 'pause' : 'play' }}"></i>
                                                </button>
                                                <form action="{{ route('contacts.crm.destroy', $connection) }}" 
                                                      method="POST" 
                                                      class="d-inline"
                                                      onsubmit="return confirm('{{ __('crm.confirm_delete') }}')">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-sm btn-outline-danger" title="{{ __('crm.delete_connection') }}">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="6" class="text-center py-4">
                                            <div class="text-muted">
                                                <i class="fas fa-plug fa-3x mb-3"></i>
                                                <p>{{ __('crm.no_connections') }}</p>
                                                <a href="{{ route('contacts.crm.create') }}" class="btn btn-primary">
                                                    {{ __('crm.create_first_connection') }}
                                                </a>
                                            </div>
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    @if($connections->hasPages())
                        <div class="card-footer py-4">
                            {{ $connections->links() }}
                        </div>
                    @endif
                </div>
            </div>
        </div>

        @include('layouts.footers.auth')
    </div>
@endsection

@push('css')
<style>
.btn-group .btn {
    border-radius: 0.25rem !important;
    margin-right: 2px;
    min-width: 32px;
    height: 32px;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    padding: 0.25rem 0.5rem;
}

.btn-group .btn:last-child {
    margin-right: 0;
}

.btn-group .btn i {
    font-size: 12px;
}

.btn-outline-primary:hover {
    background-color: #007bff;
    border-color: #007bff;
    color: white;
}

.btn-outline-secondary:hover {
    background-color: #6c757d;
    border-color: #6c757d;
    color: white;
}

.btn-outline-success:hover {
    background-color: #28a745;
    border-color: #28a745;
    color: white;
}

.btn-outline-warning:hover {
    background-color: #ffc107;
    border-color: #ffc107;
    color: #212529;
}

.btn-outline-danger:hover {
    background-color: #dc3545;
    border-color: #dc3545;
    color: white;
}
</style>
@endpush

@push('js')
<script>
    // Pass route URLs to JavaScript
    window.crmRoutes = {
        test: '{{ route("contacts.crm.test") }}',
        fields: '{{ route("contacts.crm.fields") }}'
    };
</script>
<script>
function toggleConnectionStatus(connectionId) {
    const button = event.target.closest('button');
    const originalContent = button.innerHTML;
    
    // Show loading state
    button.disabled = true;
    button.innerHTML = '<i class="fas fa-spinner fa-spin"></i>';
    
    const url = '{{ route("contacts.crm.toggle-status", ["crmConnection" => "PLACEHOLDER"]) }}'.replace('PLACEHOLDER', connectionId);
    fetch(url, {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': '{{ csrf_token() }}',
            'Content-Type': 'application/json',
        },
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            // Show success feedback
            button.innerHTML = '<i class="fas fa-check"></i>';
            button.classList.remove('btn-outline-warning', 'btn-outline-success');
            button.classList.add('btn-success');
            
            // Reload after a short delay
            setTimeout(() => {
                location.reload();
            }, 1000);
        } else {
            // Show error feedback
            button.innerHTML = '<i class="fas fa-times"></i>';
            button.classList.add('btn-danger');
            alert(data.message || '{{ __('crm.status_toggle_failed') }}');
            
            // Restore original state after delay
            setTimeout(() => {
                button.innerHTML = originalContent;
                button.disabled = false;
                button.classList.remove('btn-danger');
            }, 2000);
        }
    })
    .catch(error => {
        console.error('Error:', error);
        // Show error feedback
        button.innerHTML = '<i class="fas fa-times"></i>';
        button.classList.add('btn-danger');
        alert('{{ __('crm.status_toggle_failed') }}');
        
        // Restore original state after delay
        setTimeout(() => {
            button.innerHTML = originalContent;
            button.disabled = false;
            button.classList.remove('btn-danger');
        }, 2000);
    });
}
</script>
@endpush