<script type="text/javascript">
$(document).ready(function() {
    // Handle "Select All" checkbox
    $('#select-all').change(function() {
        $('.select-item').prop('checked', $(this).is(':checked'));
        updateSelectedCount();
        toggleBulkActionButton();
    });

    // Handle individual checkbox change
    $('.select-item').change(function() {
        updateSelectedCount();
        toggleBulkActionButton();
    });

    // Handle individual checkbox change
    $('.select-item').change(function() {
        updateSelectedCount();
    });

    // Update the number of selected items
    function updateSelectedCount() {
        var count = $('.select-item:checked').length;
        $('#selected-count').text(count + ' records selected');
    }

    // Handle "Move to group" action
    $('#move-to-group').click(function(e) {
        e.preventDefault();
        $('#move-to-group-modal').modal('show');
    });

    // Handle "Move" button click in the modal
    $('#move-to-group-confirm').click(function() {
        var selectedIds = getSelectedIds();
        var selectedGroupId = $('input[name="group"]:checked').val();

        // Make an AJAX call to assign the selected items to the selected group
        $.ajax({
            url: '/contacts/contacts/assigntogroup/' + selectedIds.join(',')+"?group_id="+selectedGroupId,
            type: 'GET',
            success: function(result) {
                // Handle success here
                console.log('Successfully assigned:', result);

                // Close the modal
                $('#move-to-group-modal').modal('hide');

                js.notify(result.message, 'success');

                // Refresh the page after 4 seconds
                setTimeout(function() {
                            location.reload();
                        }, 4000);
            },
            error: function(xhr, status, error) {
                // Handle error here
                console.log('Error:', error);
                js.notify(error, 'error');
            }
        });
    });

    // Handle "Remove from group" action
    $('#remove-from-group').click(function(e) {
        e.preventDefault();
        $('#remove-from-group-modal').modal('show');
    });

    // Handle "Remove" button click in the modal
    $('#remove-from-group-confirm').click(function() {
        var selectedIds = getSelectedIds();
        var selectedGroupId = $('input[name="groupremove"]:checked').val();

        // Make an AJAX call to remove the selected items from the selected groups
        $.ajax({
            url: '/contacts/contacts/removefromgroup/' + selectedIds.join(',')+"?group_id="+selectedGroupId,
            type: 'GET',
            success: function(result) {
                // Handle success here
                console.log('Successfully removed:', result);

                // Close the modal
                $('#remove-from-group-modal').modal('hide');

                js.notify(result.message, 'success');

                // Refresh the page after 4 seconds
                setTimeout(function() {
                    location.reload();
                }, 4000);
            },
            error: function(xhr, status, error) {
                // Handle error here
                console.log('Error:', error);
                js.notify(error, 'error');
            }
        });
    });


     // Handle "Subscribe selected" action
     $('#subscribe-contact').click(function(e) {
        e.preventDefault();
        var selectedIds = getSelectedIds();

        // Now you have all selected IDs in the `selectedIds` array
        // Add your code here to delete the selected items
        if (confirm('Subscribe selected contact\nAre you sure you would like to do this?')) {
            // User confirmed deletion
            // Now you have all selected IDs in the `selectedIds` array
            // Add your code here to delete the selected items
            console.log('Delete selected:', selectedIds);

            $.ajax({
                url: '/contacts/contacts/subscribe/' + selectedIds.join(','),
                type: 'GET',
                success: function(result) {
                    // Handle success here
                    js.notify(result.message, 'success');

                    // Refresh the page after 4 seconds
                    setTimeout(function() {
                        location.reload();
                    }, 3000);
                },
                error: function(xhr, status, error) {
                    // Handle error here
                    console.log('Error:', error);
                    js.notify(error, 'error');
                }
            });


        }
    });

    // Handle "Subscribe selected" action
    $('#unsubscribe-contact').click(function(e) {
        e.preventDefault();
        var selectedIds = getSelectedIds();

        // Now you have all selected IDs in the `selectedIds` array
        // Add your code here to delete the selected items
        if (confirm('Unsubscribe selected contact\nAre you sure you would like to do this?')) {
            // User confirmed deletion
            // Now you have all selected IDs in the `selectedIds` array
            // Add your code here to delete the selected items
            console.log('Delete selected:', selectedIds);

            $.ajax({
                url: '/contacts/contacts/unsubscribe/' + selectedIds.join(','),
                type: 'GET',
                success: function(result) {
                    // Handle success here
                    js.notify(result.message, 'success');

                    // Refresh the page after 4 seconds
                    setTimeout(function() {
                        location.reload();
                    }, 3000);
                },
                error: function(xhr, status, error) {
                    // Handle error here
                    console.log('Error:', error);
                    js.notify(error, 'error');
                }
            });


        }
    });

    // Handle "Assign to Agent" action (Only for Owners)
    $('#assign-to-agent').click(function(e) {
        e.preventDefault();
        $('#assign-to-agent-modal').modal('show');
    });

    // Reset modal when closed
    $('#assign-to-agent-modal').on('hidden.bs.modal', function () {
        // Uncheck all radio buttons
        $('input[name="agent"]').prop('checked', false);
        // Reset button state
        var $btn = $('#assign-to-agent-confirm');
        $btn.prop('disabled', false);
        $btn.find('.btn-text').show();
        $btn.find('.btn-spinner').hide();
    });

    // Handle "Assign" button click in the agent modal
    $('#assign-to-agent-confirm').click(function() {
        var selectedIds = getSelectedIds();
        var selectedAgentId = $('input[name="agent"]:checked').val();

        if (selectedAgentId === undefined) {
            js.notify('Please select an agent or choose "Unassign"', 'warning');
            return;
        }

        // Show loading state
        var $btn = $('#assign-to-agent-confirm');
        $btn.prop('disabled', true);
        $btn.find('.btn-text').hide();
        $btn.find('.btn-spinner').show();

        // Make an AJAX call to assign the selected contacts to the selected agent
        $.ajax({
            url: '/contacts/contacts/assigntoagent/' + selectedIds.join(',') + "?agent_id=" + selectedAgentId,
            type: 'GET',
            success: function(result) {
                console.log('Successfully assigned to agent:', result);
                
                // Close modal immediately
                $('#assign-to-agent-modal').modal('hide');
                
                // Show success message
                js.notify(result.message, 'success');

                // Reload page after short delay to show success message
                setTimeout(function() {
                    location.reload();
                }, 1500);
            },
            error: function(xhr, status, error) {
                console.log('Error:', error);
                var errorMessage = xhr.responseJSON?.message || 'Failed to assign contacts to agent';
                js.notify(errorMessage, 'error');
                
                // Reset button state on error
                $btn.prop('disabled', false);
                $btn.find('.btn-text').show();
                $btn.find('.btn-spinner').hide();
            }
        });
    });

    // Handle "Delete selected" action
    $('#delete-selected').click(function(e) {
        e.preventDefault();
        var selectedIds = getSelectedIds();

        // Now you have all selected IDs in the `selectedIds` array
        // Add your code here to delete the selected items
        if (confirm('Delete selected items\nAre you sure you would like to do this?')) {
            // User confirmed deletion
            // Now you have all selected IDs in the `selectedIds` array
            // Add your code here to delete the selected items
            console.log('Delete selected:', selectedIds);

            $.ajax({
                url: '/contacts/contacts/bulkremove/' + selectedIds.join(','),
                type: 'GET',
                success: function(result) {
                    // Handle success here
                    js.notify(result.message, 'success');

                    // Refresh the page after 4 seconds
                    setTimeout(function() {
                        location.reload();
                    }, 3000);
                },
                error: function(xhr, status, error) {
                    // Handle error here
                    console.log('Error:', error);
                    js.notify(error, 'error');
                }
            });


        }
    });

    // Show or hide bulk action button
    function toggleBulkActionButton() {
        if ($('.select-item:checked').length > 0) {
            $('#bulk-action-button').show();
        } else {
            $('#bulk-action-button').hide();
        }
    }

    // Get IDs of all selected items
    function getSelectedIds() {
        return $('.select-item:checked').map(function() {
            return $(this).val();
        }).get();
    }
});
</script>
