

<div class="col-xl-5 mt-2">
    <div class="card shadow premium-card">
        <div class="card-header premium-header border-0">
            <div class="row align-items-center">
                <div class="col">
                    <h3 class="mb-0">{{__('Template Builder')}}</h3>
                </div>
                <div class="col text-right">
                    <small class="text-white op-8">Live Validation On</small>
                </div>
            </div>
        </div>
        <div class="card-body p-4">
            <!-- Header Section -->
            <label class="form-section-label">{{__('1. Header (Optional)')}}</label>
            <div class="form-group">
                <select name="header" id="header" class="form-control form-control-premium" v-model="headerType">
                    <option value="none">{{__('No Header')}}</option>
                    <option value="text">{{__('Text Header')}}</option>
                    <option value="image">{{__('Image')}}</option>
                    <option value="video">{{__('Video')}}</option>
                    <option value="pdf">{{__('PDF Document')}}</option>
                </select>
            </div>

            <!-- Header Text Logic -->
            <div v-if="headerType=='text'" class="form-group position-relative">
                <div class="input-group-premium" :class="{'invalid': headerText.length > 60}">
                    <input v-model="headerText" type="text" class="form-control form-control-premium pr-5"
                        placeholder="{{__('Enter header title...')}}">
                    <!-- Icon -->
                    <i v-if="headerText.length > 0 && headerText.length <= 60"
                        class="ni ni-check-bold validation-icon success"></i>
                    <i v-if="headerText.length > 60" class="ni ni-fat-remove validation-icon error"></i>
                </div>

                <div class="d-flex justify-content-between mt-1">
                    <small class="text-danger feedback-message" :class="{'show': headerText.length > 60}">
                        {{__('Header limit exceeded (Max 60)')}}
                    </small>
                    <small class="text-counter" :class="{'text-danger': headerText.length > 60}">
                        @{{ headerText.length }}/60
                    </small>
                </div>

                <button type="button" class="btn btn-outline-primary btn-sm mt-2" @click="addHeaderVariable()">
                    {{__('+ Add Variable')}} @{{1}}
                </button>

                <!-- Variable Sample -->
                <div class="mt-3 analysis-box" v-if="headervariableAdded">
                    <label class="small text-muted font-weight-bold">{{__('Variable Sample Content')}}</label>
                    <div class="input-group">
                        <div class="input-group-prepend">
                            <span class="input-group-text bg-white">@{{ '{' }}{1}@{{ '}' }}</span>
                        </div>
                        <input v-model="headerExampleVariable" type="text" class="form-control"
                            placeholder="e.g. Summer Sale">
                    </div>
                </div>
            </div>

            <!-- Media Inputs -->
            <div v-if="headerType=='image'" class="form-group">
                <div class="custom-file">
                    <input @change="handleImageUpload" type="file" accept="image/*" class="custom-file-input"
                        id="header_image" lang="en">
                    <label class="custom-file-label" for="header_image">{{__('Select Image...')}}</label>
                </div>
            </div>
            <div v-if="headerType=='video'" class="form-group">
                <div class="custom-file">
                    <input @change="handleVideoUpload" type="file" accept="video/*" class="custom-file-input"
                        id="header_video" lang="en">
                    <label class="custom-file-label" for="header_video">{{__('Select Video...')}}</label>
                </div>
            </div>
            <div v-if="headerType=='pdf'" class="form-group">
                <div class="custom-file">
                    <input type="file" accept="application/pdf" class="custom-file-input" id="header_pdf" lang="en">
                    <label class="custom-file-label" for="header_pdf">{{__('Select PDF...')}}</label>
                </div>
            </div>

            <hr class="my-4" />

            <!-- Body Section -->
            <label class="form-section-label">{{__('2. Message Body')}} <span class="text-danger">*</span></label>
            <div class="form-group">
                <div class="input-group-premium" :class="{'invalid': bodyText.length > 1024 || bodyRatioError}">
                    <textarea 
                        id="body"
                        rows="6" 
                        v-model="bodyText" 
                        class="form-control form-control-premium" 
                        style="resize: none;"
                        :placeholder="'Hi {{1}}, welcome to our service! ...'"
                    ></textarea>
                </div>

                <!-- Progress Bar for Body -->
                <div class="mt-2">
                    <div class="progress" style="height: 6px;">
                        <div class="progress-bar" 
                            :class="{'bg-success': bodyText.length <= 800, 'bg-warning': bodyText.length > 800 && bodyText.length <= 1024, 'bg-danger': bodyText.length > 1024}"
                            :style="'width: ' + Math.min((bodyText.length / 1024) * 100, 100) + '%'"></div>
                    </div>
                    <div class="d-flex justify-content-between mt-1">
                        <div>
                            <small v-if="bodyText.length === 0" class="text-muted">
                                <i class="fas fa-lightbulb text-warning"></i> {{__('Tip: Write a clear message your customers will understand')}}
                            </small>
                            <small class="text-danger feedback-message" :class="{'show': bodyText.length > 1024}">
                                <i class="ni ni-fat-remove"></i> {{__('Almost there! Remove')}} @{{ bodyText.length - 1024 }} {{__('characters')}}
                            </small>
                            <small class="text-danger feedback-message" :class="{'show': bodyRatioError}">
                                <i class="ni ni-fat-remove"></i> {{__('Add more text around your placeholders for Meta approval')}}
                            </small>
                        </div>
                        <small class="text-counter" :class="{'text-danger': bodyText.length > 1024, 'text-success': bodyText.length > 0 && bodyText.length <= 1024}">
                            <strong>@{{ bodyText.length }}</strong>/1024
                        </small>
                    </div>
                </div>

                <!-- Formatting Toolbar -->
                <div class="btn-group mt-2">
                    <button @click="addBold()" type="button" class="btn btn-secondary btn-sm" title="Bold"><i
                            class="fas fa-bold"></i></button>
                    <button @click="addItalic()" type="button" class="btn btn-secondary btn-sm" title="Italic"><i
                            class="fas fa-italic"></i></button>
                    <button @click="addCode()" type="button" class="btn btn-secondary btn-sm" title="Monospace"><i
                            class="fas fa-code"></i></button>
                    <button @click="addVariable()" type="button"
                        class="btn btn-primary btn-sm ml-2">{{ __('+ Add Variable')}}</button>
                </div>

                <!-- Body Variable Samples -->
                <div class="mt-3 analysis-box" v-if="bodyVariables">
                    <label class="small text-muted font-weight-bold">{{__('Variable Samples')}}</label>
                    <p class="small text-muted mb-2">Provide examples for Meta review (e.g. name, date).</p>
                    <div v-for="(v, index) in bodyVariables" class="input-group mb-2">
                        <div class="input-group-prepend">
                            <span class="input-group-text bg-white font-weight-bold">@{{v}}</span>
                        </div>
                        <input v-model="bodyExampleVariable[index]" type="text" class="form-control"
                            placeholder="Sample content...">
                    </div>
                </div>
            </div>

            <hr class="my-4" />

            <!-- Footer Section -->
            <label class="form-section-label">{{__('3. Footer (Optional)')}}</label>
            <div class="form-group">
                <div class="input-group-premium" :class="{'invalid': footerText.length > 60}">
                    <input v-model="footerText" type="text" class="form-control form-control-premium pr-5"
                        placeholder="{{__('Add a short footer...')}}">
                    <small class="text-counter position-absolute" style="right: 10px; bottom: 12px; z-index:5;"
                        :class="{'text-danger': footerText.length > 60}">
                        @{{ footerText.length }}/60
                    </small>
                </div>
            </div>

            <hr class="my-4" />

            <!-- Buttons Section -->
            <label class="form-section-label">{{__('4. Interactive Buttons')}}</label>

            <div class="text-right mb-3">
                <div class="dropdown">
                    <button class="btn btn-primary btn-sm dropdown-toggle" type="button" data-toggle="dropdown">
                        {{ __('+ Add Button')}}
                    </button>
                    <div class="dropdown-menu dropdown-menu-right">
                        <a class="dropdown-item" href="#" @click.prevent="addQuickReply()">{{ __('Quick Reply')}}</a>
                        <a class="dropdown-item" href="#" @click.prevent="addVisitWebsite()"
                            :class="{'disabled': vistiWebsite.length>1}">{{ __('Visit Website')}}</a>
                        <a class="dropdown-item" href="#" @click.prevent="addCallPhone()"
                            v-if="!hasPhone">{{ __('Phone Number')}}</a>
                        <!-- Note: COPY_CODE (Offer Code) is only for AUTHENTICATION templates, not Marketing/Utility -->
                        <!-- Removed: Offer Code button - not supported for Marketing/Utility categories -->
                        <a class="dropdown-item" href="#" @click.prevent="addDynamicUrl()"
                            :class="{'disabled': dynamicUrls.length>1}">{{ __('Dynamic URL')}}</a>
                    </div>
                </div>
            </div>

            <!-- Quick Replies List -->
            <div v-if="quickReplies.length>0" class="mb-3">
                <label class="small font-weight-bold text-muted">{{__('Quick Replies')}} <span class="text-info">({{__('Max 20 characters each')}})</span></label>
                <div v-for="(v, index) in quickReplies" class="form-group mb-2">
                    <div class="input-group input-group-premium" :class="{'invalid': v.length > 20, 'valid': v.length > 0 && v.length <= 20}">
                        <input v-model="quickReplies[index]" type="text" class="form-control form-control-premium"
                            placeholder="{{__('e.g. Yes, I\'m interested')}}" maxlength="20">
                        <div class="input-group-append">
                            <span class="input-group-text bg-white text-muted small">@{{ v.length }}/20</span>
                            <button class="btn btn-outline-danger" type="button" @click="deleteQuickReply(index)"><i
                                    class="fas fa-trash"></i></button>
                        </div>
                    </div>
                    <small class="text-danger feedback-message"
                        :class="{'show': v.length > 20}">{{__('Keep it short! Max 20 characters.')}}</small>
                </div>
            </div>

            <!-- Website Buttons -->
            <div v-if="vistiWebsite.length>0" class="mb-3">
                <label class="small font-weight-bold text-muted">{{__('Website Buttons')}}</label>
                <div v-for="(v, index) in vistiWebsite" class="analysis-box mt-0 mb-2">
                    <div class="form-group">
                        <label class="small">{{__('Label')}}</label>
                        <input v-model="vistiWebsite[index]['title']" type="text"
                            class="form-control form-control-premium" placeholder="Button Label"
                            :class="{'is-invalid': vistiWebsite[index]['title'].length > 25}">
                        <small class="text-danger"
                            v-if="vistiWebsite[index]['title'].length > 25">{{__('Max 25 chars')}}</small>
                    </div>
                    <div class="form-group mb-0">
                        <label class="small">{{__('URL (must start with http:// or https://)')}}</label>
                        <div class="input-group-premium"
                            :class="{'invalid': vistiWebsite[index]['url'].length > 0 && !isValidURL(vistiWebsite[index]['url']), 'valid': isValidURL(vistiWebsite[index]['url'])}">
                            <input v-model="vistiWebsite[index]['url']" type="text"
                                class="form-control form-control-premium pr-5" placeholder="https://example.com">
                            <i v-if="isValidURL(vistiWebsite[index]['url'])"
                                class="ni ni-check-bold validation-icon success"></i>
                            <i v-if="vistiWebsite[index]['url'].length > 0 && !isValidURL(vistiWebsite[index]['url'])"
                                class="ni ni-fat-remove validation-icon error"></i>
                        </div>
                        <small class="text-danger feedback-message"
                            :class="{'show': vistiWebsite[index]['url'].length > 0 && !isValidURL(vistiWebsite[index]['url'])}">{{__('Invalid URL format')}}</small>
                    </div>
                    <button class="btn btn-sm btn-link text-danger mt-2 p-0"
                        @click="deleteVisitWebsite(index)">{{__('Remove Button')}}</button>
                </div>
            </div>

            <!-- Dynamic URL Buttons -->
            <div v-if="dynamicUrls.length>0" class="mb-3">
                <label class="small font-weight-bold text-muted">{{__('Dynamic URL Buttons')}}</label>
                <div v-for="(v, index) in dynamicUrls" class="analysis-box mt-0 mb-2">
                    <div class="form-group">
                        <label class="small">{{__('Label')}}</label>
                        <input v-model="dynamicUrls[index]['text']" type="text"
                            class="form-control form-control-premium" placeholder="View Order"
                            :class="{'is-invalid': dynamicUrls[index]['text'].length > 25}">
                    </div>
                    <div class="form-group">
                        <label class="small">{{__('Base URL')}}</label>
                        <div class="input-group-premium"
                            :class="{'invalid': dynamicUrls[index]['url'].length > 0 && !isValidURL(dynamicUrls[index]['url']), 'valid': isValidURL(dynamicUrls[index]['url'])}">
                            <input v-model="dynamicUrls[index]['url']" type="text"
                                class="form-control form-control-premium" placeholder="https://site.com/order/">
                        </div>
                        <small class="text-danger feedback-message"
                            :class="{'show': dynamicUrls[index]['url'].length > 0 && !isValidURL(dynamicUrls[index]['url'])}">{{__('Invalid URL format')}}</small>
                    </div>
                    <div class="form-group mb-0">
                        <label class="small">{{__('Sample Suffix')}}</label>
                        <input v-model="dynamicUrls[index]['example']" type="text" class="form-control"
                            placeholder="12345">
                    </div>
                    <button class="btn btn-sm btn-link text-danger mt-2 p-0"
                        @click="deleteDynamicUrl(index)">{{__('Remove Button')}}</button>
                </div>
            </div>

            <!-- Phone Button -->
            <div v-if="hasPhone" class="analysis-box mb-3">
                <label class="small font-weight-bold">
                    {{__('Phone Button')}}
                    <i class="fas fa-question-circle text-info ml-1" data-toggle="tooltip" title="{{__('Enter country code and phone number. Total 7-15 digits required.')}}"></i>
                </label>
                <div class="row">
                    <div class="col-12 mb-2">
                        <input v-model="callPhoneButtonText" type="text" class="form-control form-control-premium"
                            placeholder="{{__('e.g. Call Us Now')}}" maxlength="25"
                            :class="{'is-invalid': callPhoneButtonText.length > 25}">
                        <small class="text-muted">{{__('Button text')}} (@{{ callPhoneButtonText.length }}/25)</small>
                    </div>
                    <div class="col-4">
                        <label class="small text-muted">{{__('Country Code')}}</label>
                        <input v-model="dialCode" type="tel" class="form-control" 
                            placeholder="{{__('e.g. 971')}}" 
                            oninput="this.value = this.value.replace(/[^0-9]/g, '')"
                            :class="{'is-valid': dialCode.length > 0, 'is-invalid': hasPhone && dialCode.length === 0}">
                    </div>
                    <div class="col-8">
                        <label class="small text-muted">{{__('Phone Number')}}</label>
                        <input v-model="phoneNumber" type="tel" class="form-control" 
                            placeholder="{{__('e.g. 501234567')}}" 
                            oninput="this.value = this.value.replace(/[^0-9]/g, '')"
                            :class="{'is-valid': phoneNumber.length >= 6, 'is-invalid': hasPhone && phoneNumber.length < 6}">
                    </div>
                </div>
                <small class="text-muted mt-2 d-block">
                    <i class="fas fa-phone"></i> {{__('Will be sent as:')}} <strong>+@{{ dialCode }}@{{ phoneNumber }}</strong> ({{__('international format')}})
                </small>
                <small v-if="!isValidPhoneNumber()" class="text-danger d-block mt-1">
                    <i class="ni ni-fat-remove"></i> {{__('Phone must be 7-15 digits total (country code + number)')}}
                </small>
                <button class="btn btn-sm btn-link text-danger mt-2 p-0"
                    @click="deletePhone()">{{__('Remove Button')}}</button>
            </div>

            <!-- Copy Code Button - DISABLED: Only for Authentication templates (OTP) -->
            <!-- Not supported for Marketing/Utility categories per Meta API -->
            <!-- 
            <div v-if="copyOfferCode" class="analysis-box mb-3">
                <label class="small font-weight-bold">{{__('Copy Code Button')}}</label>
                <input v-model="offerCode" type="text" class="form-control form-control-premium"
                    placeholder="Coupon Code (e.g. SAVE20)" maxlength="15">
                <small class="text-muted d-block mt-1">{{__('Max 15 chars for code')}}</small>
                <button class="btn btn-sm btn-link text-danger mt-2 p-0"
                    @click="deleteCopyOfferCode()">{{__('Remove Button')}}</button>
            </div>
            -->


        </div>
    </div>
</div>