<!-- Template Basics -->
<div class="col-xl-3 mt-2">
    <div class="card shadow premium-card">
        <div class="card-header premium-header border-0">
            <div class="row align-items-center">
                <div class="col">
                    <h3 class="mb-0 text-white">{{__('Template Basics')}}</h3>
                </div>
            </div>
        </div>
        <div class="card-body p-4">

            <!-- Template Name -->
            <label class="form-section-label">
                {{__('Template Name')}} <span class="text-danger">*</span>
                <i class="fas fa-question-circle text-info ml-1" data-toggle="tooltip" title="{{__('A unique name for your template. Use only lowercase letters, numbers, and underscores.')}}"></i>
            </label>
            <div class="form-group">
                <div class="input-group-premium"
                    :class="{'invalid': !validation.name && touched.name, 'valid': validation.name}">
                    <input v-model="template_name" @blur="touched.name = true" type="text" name="name" id="name"
                        class="form-control form-control-premium pr-5" placeholder="{{__('e.g. welcome_message')}}"
                        required>
                    <!-- Icons -->
                    <i v-if="validation.name" class="ni ni-check-bold validation-icon success"></i>
                    <i v-if="!validation.name && touched.name" class="ni ni-fat-remove validation-icon error"></i>
                </div>
                <!-- Feedback -->
                <small v-if="!touched.name" class="text-muted">
                    <i class="fas fa-lightbulb text-warning"></i> {{__('Example: order_confirmation, promotional_offer')}}
                </small>
                <small class="feedback-message text-danger" :class="{'show': !validation.name && touched.name}">
                    {{__('Give your template a unique name (lowercase, numbers, underscores only)')}}
                </small>
            </div>

            <!-- Template Category -->
            <label class="form-section-label">
                {{__('Category')}} <span class="text-danger">*</span>
                <i class="fas fa-question-circle text-info ml-1" data-toggle="tooltip" title="{{__('Marketing: For promotional content. Utility: For order updates, reminders, etc.')}}"></i>
            </label>
            <div class="form-group">
                <div class="input-group-premium"
                    :class="{'valid': validation.category}">
                    <select v-model="category" @blur="touched.category = true" name="category" id="category"
                        class="form-control form-control-premium">
                        <option value="MARKETING">📢 {{__('Marketing')}} - {{__('Promotions & offers')}}</option>
                        <option value="UTILITY">🔧 {{__('Utility')}} - {{__('Order updates, reminders')}}</option>
                    </select>
                </div>
                <small class="text-muted">
                    <i class="fas fa-info-circle"></i> {{__('Choose based on your message purpose')}}
                </small>
            </div>

            <!-- Template Language -->
            <label class="form-section-label">
                {{__('Language')}} <span class="text-danger">*</span>
                <i class="fas fa-question-circle text-info ml-1" data-toggle="tooltip" title="{{__('Select the language your customers will read this message in.')}}"></i>
            </label>
            <div class="form-group">
                <div class="input-group-premium"
                    :class="{'invalid': !validation.language && touched.language, 'valid': validation.language}">
                    <select v-model="language" @blur="touched.language = true" name="language" id="language"
                        class="form-control form-control-premium">
                        <option value="">🌍 {{__('Select language...')}}</option>
                        @foreach ($languages as $language)
                            <option value="{{ $language[1] }}">{{ $language[0] }}</option>
                        @endforeach
                    </select>
                </div>
                <small v-if="!touched.language" class="text-muted">
                    <i class="fas fa-globe"></i> {{__('Pick the language your customers speak')}}
                </small>
                <small class="feedback-message text-danger" :class="{'show': !validation.language && touched.language}">
                    {{__('Please select a language for your template')}}
                </small>
            </div>

        </div>
    </div>
</div>