@extends('layouts.app', ['title' => __('Send new campaign')])
@section('head')
    <style>
        /* Futuristic / Premium UI Styles */
        .premium-card {
            border: none;
            border-radius: 16px;
            background: #fff;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.05);
            overflow: hidden;
        }

        .premium-header {
            background: linear-gradient(87deg, #5e72e4 0, #825ee4 100%) !important;
            padding: 20px 30px;
        }

        .premium-header h3 {
            color: #fff !important;
            font-weight: 700;
            letter-spacing: 0.5px;
            margin: 0;
        }

        .form-section-label {
            color: #8898aa;
            text-transform: uppercase;
            font-size: 0.75rem;
            font-weight: 700;
            letter-spacing: 1px;
            margin-bottom: 15px;
            margin-top: 10px;
            display: block;
        }

        /* Input Groups */
        .input-group-premium {
            position: relative;
            background: #fff;
            border: 2px solid #e9ecef;
            border-radius: 8px;
            transition: all 0.3s ease;
            overflow: hidden;
        }

        .input-group-premium:focus-within {
            border-color: #5e72e4;
            background: #fff;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
            transform: translateY(-2px);
        }

        .input-group-premium.valid {
            border-color: #2dce89;
        }

        .input-group-premium.invalid {
            border-color: #fb6340;
            animation: shake 0.5s;
        }

        .form-control-premium {
            border: 1px solid #e9ecef;
            border-radius: 8px !important;
            padding: 12px 15px;
            height: auto;
            font-size: 1rem;
            background: transparent;
            transition: border-color 0.2s;
        }

        .form-control-premium:focus {
            border-color: #5e72e4;
            box-shadow: none;
        }

        /* Variable Badge */
        .var-badge {
            background: #e9ecef;
            color: #525f7f;
            padding: 4px 8px;
            border-radius: 4px;
            font-family: monospace;
            font-weight: bold;
            display: inline-block;
            margin-right: 5px;
            margin-bottom: 5px;
        }

        /* Validation Icons */
        .validation-icon {
            position: absolute;
            right: 15px;
            top: 50%;
            transform: translateY(-50%);
            z-index: 10;
            font-size: 1.2rem;
        }

        .validation-icon.success {
            color: #2dce89;
        }

        .validation-icon.error {
            color: #fb6340;
        }

        /* Messages */
        .feedback-message {
            font-size: 0.85rem;
            margin-top: 5px;
            display: block;
            opacity: 0;
            transform: translateY(-10px);
            transition: all 0.3s ease;
        }

        .feedback-message.show {
            opacity: 1;
            transform: translateY(0);
        }

        .text-counter {
            font-size: 0.8rem;
            color: #adb5bd;
            text-align: right;
            margin-top: 4px;
        }

        @keyframes shake {
            0% {
                transform: translateX(0);
            }

            25% {
                transform: translateX(-5px);
            }

            50% {
                transform: translateX(5px);
            }

            75% {
                transform: translateX(-5px);
            }

            100% {
                transform: translateX(0);
            }
        }

        .analysis-box {
            background: #f6f9fc;
            border-left: 4px solid #5e72e4;
            padding: 15px;
            border-radius: 4px;
            margin-top: 15px;
        }
    </style>
@endsection

@section('content')
    <div class="header  pb-8 pt-5 pt-md-8">
        <div class="container-fluid">
            <div class="header-body">
                <h1 class="mb-3 mt--3">{{__('Create new template')}}</h1>
                <div class="row align-items-center pt-2">
                </div>
            </div>
        </div>
    </div>

    <form method="POST" action="{{ route('campaigns.store') }}" id="template_creator" enctype="multipart/form-data">
        @csrf
        <div class="container-fluid mt--7" id="tempplate_managment">
            <!-- Global Validation Error Banner -->
            <div v-cloak v-if="!canSubmit && Object.keys(touched).length > 0" class="alert alert-danger fade show mb-4"
                role="alert">
                <span class="alert-icon"><i class="ni ni-bell-55"></i></span>
                <span class="alert-text"><strong>{{__('Attention!')}}</strong>
                    {{__('Please fix the highlighted validation errors before submitting.')}}</span>
            </div>
            <div class="row">
                @include('wpbox::templates.partials.basic')
                @include('wpbox::templates.partials.form')
                @include('wpbox::templates.partials.preview')
            </div>
        </div>
    </form>
    @include('wpbox::templates.scripts')
@endsection