<!-- Template Preview -->
<div class="card shadow sticky-top" style="top: 20px;">
    <div class="card-header text-white border-0" style="background: linear-gradient(135deg, #25D366 0%, #128C7E 100%);">
        <div class="row align-items-center">
            <div class="col">
                <h3 class="mb-0 text-white"><i class="fab fa-whatsapp mr-2"></i>{{__('Live Preview')}}</h3>
            </div>
            <div class="col-auto">
                <span class="badge"
                    style="background: rgba(0,0,0,0.3); color: white; font-weight: 600; padding: 6px 12px; font-size: 0.85rem;">{{__('Step')}}
                    @{{ currentStep }}/6</span>
            </div>
        </div>
    </div>
    <div class="card-body">
        @include('wpbox::templates.partials.message')

        <!-- Validation Status -->
        <div class="mt-3 p-3 rounded" style="transition: all 0.3s ease;"
            :style="canSubmit ? 'background: rgba(37, 211, 102, 0.1); border: 2px solid #25D366;' : 'background: rgba(220, 53, 69, 0.1); border: 2px solid #dc3545;'">
            <div v-if="canSubmit" class="text-center">
                <i class="fas fa-check-circle fa-2x mb-2" style="color: #25D366;"></i>
                <div style="color: #128C7E;">
                    <strong style="font-size: 1.1rem;">{{__('✨ Ready to submit!')}}</strong>
                    <p class="mb-0 mt-1 small">{{__('All fields validated successfully')}}</p>
                </div>
            </div>
            <div v-else class="text-center">
                <i class="fas fa-exclamation-circle fa-2x mb-2" style="color: #dc3545;"></i>
                <div class="text-danger">
                    <strong style="font-size: 1.1rem;">{{__('⚠️ Incomplete Form')}}</strong>
                    <p class="mb-0 mt-1 small">{{__('Please fill all required fields correctly')}}</p>
                </div>
            </div>
        </div>
    </div>
</div>