<div class="card-body p-3"
    style="background: #ECE5DD url('{{ asset('uploads/default/wpbox/bg.png') }}') repeat; min-height: 400px; display: flex; flex-direction: column; justify-content: flex-end;">

    <!-- WhatsApp Message Bubble -->
    <div class="d-flex justify-content-end mb-2">
        <div
            style="max-width: 85%; background: #DCF8C6; border-radius: 8px; box-shadow: 0 1px 2px rgba(0,0,0,0.1); overflow: hidden;">

            <!-- Header Media/Text -->
            <div v-if="headerType=='image' && headerImage" style="background: #fff;">
                <img :src="headerImage" style="width: 100%; display: block; border-radius: 8px 8px 0 0;">
            </div>
            <div v-if="headerType=='video' && headerVideo.length>4" style="background: #000;">
                <video width="100%" height="200" controls style="display: block;">
                    <source :src="headerVideo" type="video/mp4">
                </video>
            </div>
            <div v-if="headerType=='pdf'" style="background: #f0f0f0; padding: 15px; text-align: center;">
                <i class="fas fa-file-pdf fa-3x" style="color: #dc3545;"></i>
                <p class="mb-0 mt-2 small text-muted">{{__('PDF Document')}}</p>
            </div>

            <!-- Message Content -->
            <div style="padding: 8px 10px;">
                <h6 v-if="headerType=='text' && headerText" class="mb-2"
                    style="color: #303030; font-weight: 600; font-size: 1rem;">
                    @{{headerReplacedWithExample}}
                </h6>
                <p class="mb-1"
                    style="color: #303030; white-space: pre-wrap; font-size: 0.95rem; line-height: 1.4; word-wrap: break-word;">
                    @{{bodyReplacedWithExample || 'Your message will appear here...'}}
                </p>
                <small v-if="footerText" class="d-block mt-2" style="color: #667781; font-size: 0.8rem;">
                    @{{footerText}}
                </small>
                <div class="text-right mt-1">
                    <small style="color: #667781; font-size: 0.7rem;">
                        {{ date('H:i') }} <i class="fas fa-check-double" style="color: #25D366;"></i>
                    </small>
                </div>
            </div>

            <!-- Buttons -->
            <div v-if="quickReplies.length > 0 || vistiWebsite.length > 0 || hasPhone || dynamicUrls.length > 0"
                style="border-top: 1px solid rgba(0,0,0,0.05); background: rgba(255,255,255,0.3);">
                <!-- Quick Replies -->
                <div v-for="(reply, index) in quickReplies" :key="'qr'+index"
                    style="padding: 10px 15px; text-align: center; border-bottom: 1px solid rgba(0,0,0,0.05); cursor: pointer; transition: background 0.2s;"
                    onmouseover="this.style.background='rgba(0,0,0,0.05)'"
                    onmouseout="this.style.background='transparent'">
                    <i class="fas fa-reply mr-2" style="color: #00a5f4; font-size: 0.85rem;"></i>
                    <span style="color: #00a5f4; font-weight: 500; font-size: 0.9rem;">@{{reply}}</span>
                </div>

                <!-- Website Buttons -->
                <div v-for="(wb, index) in vistiWebsite" :key="'wb'+index"
                    style="padding: 10px 15px; text-align: center; border-bottom: 1px solid rgba(0,0,0,0.05); cursor: pointer; transition: background 0.2s;"
                    onmouseover="this.style.background='rgba(0,0,0,0.05)'"
                    onmouseout="this.style.background='transparent'">
                    <i class="fas fa-external-link-alt mr-2" style="color: #00a5f4; font-size: 0.85rem;"></i>
                    <span style="color: #00a5f4; font-weight: 500; font-size: 0.9rem;">@{{wb.title}}</span>
                </div>

                <!-- Phone Button -->
                <div v-if="hasPhone"
                    style="padding: 10px 15px; text-align: center; border-bottom: 1px solid rgba(0,0,0,0.05); cursor: pointer; transition: background 0.2s;"
                    onmouseover="this.style.background='rgba(0,0,0,0.05)'"
                    onmouseout="this.style.background='transparent'">
                    <i class="fas fa-phone mr-2" style="color: #00a5f4; font-size: 0.85rem;"></i>
                    <span style="color: #00a5f4; font-weight: 500; font-size: 0.9rem;">@{{callPhoneButtonText}}</span>
                </div>

                <!-- Dynamic URLs -->
                <div v-for="(du, index) in dynamicUrls" :key="'du'+index"
                    style="padding: 10px 15px; text-align: center; border-bottom: 1px solid rgba(0,0,0,0.05); cursor: pointer; transition: background 0.2s;"
                    onmouseover="this.style.background='rgba(0,0,0,0.05)'"
                    onmouseout="this.style.background='transparent'">
                    <i class="fas fa-link mr-2" style="color: #00a5f4; font-size: 0.85rem;"></i>
                    <span style="color: #00a5f4; font-weight: 500; font-size: 0.9rem;">@{{du.text}}</span>
                </div>

                <!-- Copy Offer Code -->
                <div v-if="copyOfferCode"
                    style="padding: 10px 15px; text-align: center; cursor: pointer; transition: background 0.2s;"
                    onmouseover="this.style.background='rgba(0,0,0,0.05)'"
                    onmouseout="this.style.background='transparent'">
                    <i class="fas fa-copy mr-2" style="color: #00a5f4; font-size: 0.85rem;"></i>
                    <span style="color: #00a5f4; font-weight: 500; font-size: 0.9rem;">{{__('Copy Offer Code')}}</span>
                </div>
            </div>
        </div>
    </div>

    <!-- WhatsApp Branding -->
    <div class="text-center mt-3">
        <small style="color: #667781; font-size: 0.7rem;">
            <i class="fas fa-lock mr-1"></i>{{__('Messages are end-to-end encrypted')}}
        </small>
    </div>

</div>