<!-- Steps 2-5 Form Content -->

<!-- ===== STEP 2: HEADER ===== -->
<div v-show="currentStep === 2">
    <h2 class="step-title"><i class="fas fa-heading mr-2"></i>{{__('Header (Optional)')}}</h2>
    <p class="step-subtitle">
        {{__('Add an eye-catching header to grab attention. This appears at the top of your message.')}}
    </p>

    <div class="form-group">
        <label class="form-section-label">{{__('Header Type')}}</label>
        <select name="header" id="header" class="form-control form-control-premium" v-model="headerType">
            <option value="none">❌ {{__('No Header')}}</option>
            <option value="text">📝 {{__('Text Header')}}</option>
            <option value="image">🖼️ {{__('Image')}}</option>
            <option value="video">🎬 {{__('Video')}}</option>
            <option value="pdf">📄 {{__('PDF Document')}}</option>
        </select>
        <div class="field-description">
            <i class="fas fa-info-circle"></i>
            {{__('Text headers are best for simple titles. Media headers (image/video) make your template more engaging.')}}
        </div>
    </div>

    <!-- Header Text -->
    <div v-if="headerType=='text'" class="form-group">
        <label class="form-section-label">{{__('Header Text')}}</label>
        <div class="input-group-premium" :class="{'invalid': headerText.length > 60}">
            <input v-model="headerText" type="text" class="form-control form-control-premium pr-5"
                placeholder="{{__('e.g. Special Offer Just For You!')}}" maxlength="60">
            <i v-if="headerText.length > 0 && headerText.length <= 60"
                class="ni ni-check-bold validation-icon success"></i>
            <i v-if="headerText.length > 60" class="ni ni-fat-remove validation-icon error"></i>
        </div>
        <div class="d-flex justify-content-between mt-1">
            <small class="text-danger feedback-message" :class="{'show': headerText.length > 60}">
                {{__('Header too long! Maximum 60 characters.')}}
            </small>
            <small class="text-counter" :class="{'text-danger': headerText.length > 60}">
                @{{ headerText.length }}/60
            </small>
        </div>
        <div class="field-description">
            <i class="fas fa-lightbulb"></i>
            {{__('Keep it short and impactful. Only ONE variable')}} <code>@{{1}}</code> {{__('allowed in header.')}}
            <span class="meta-limit">{{__('Max 60 chars')}}</span>
        </div>

        <button type="button" class="btn btn-outline-primary btn-sm mt-3" @click="addHeaderVariable()"
            :disabled="headervariableAdded">
            <i class="fas fa-plus mr-1"></i>{{__('Add Variable')}} @{{1}}
        </button>

        <!-- Variable Sample -->
        <div class="mt-3 analysis-box" v-if="headervariableAdded">
            <label class="small text-muted font-weight-bold">{{__('Variable Sample')}}</label>
            <p class="small text-muted mb-2">{{__('Provide an example value for Meta review.')}}</p>
            <div class="input-group">
                <div class="input-group-prepend">
                    <span class="input-group-text bg-white">@{{ '{' }}{1}@{{ '}' }}</span>
                </div>
                <input v-model="headerExampleVariable" type="text" class="form-control"
                    placeholder="{{__('e.g. Summer Sale')}}">
            </div>
        </div>
    </div>

    <!-- Media Inputs -->
    <div v-if="headerType=='image'" class="form-group">
        <label class="form-section-label">{{__('Upload Image')}}</label>
        <div class="custom-file">
            <input @change="handleImageUpload" type="file" accept="image/*" class="custom-file-input" id="header_image"
                lang="en">
            <label class="custom-file-label" for="header_image">{{__('Select Image...')}}</label>
        </div>
        <div class="field-description">
            <i class="fas fa-image"></i>
            {{__('Recommended: JPG or PNG format.')}}
            <span class="meta-limit">{{__('Max 5MB')}}</span>
        </div>
    </div>
    <div v-if="headerType=='video'" class="form-group">
        <label class="form-section-label">{{__('Upload Video')}}</label>
        <div class="custom-file">
            <input @change="handleVideoUpload" type="file" accept="video/*" class="custom-file-input" id="header_video"
                lang="en">
            <label class="custom-file-label" for="header_video">{{__('Select Video...')}}</label>
        </div>
        <div class="field-description">
            <i class="fas fa-video"></i>
            {{__('MP4 format recommended. Keep videos short for better engagement.')}}
            <span class="meta-limit">{{__('Max 16MB')}}</span>
        </div>
    </div>
    <div v-if="headerType=='pdf'" class="form-group">
        <label class="form-section-label">{{__('Upload PDF')}}</label>
        <div class="custom-file">
            <input type="file" accept="application/pdf" class="custom-file-input" id="header_pdf" lang="en">
            <label class="custom-file-label" for="header_pdf">{{__('Select PDF...')}}</label>
        </div>
        <div class="field-description">
            <i class="fas fa-file-pdf"></i>
            {{__('Great for brochures, menus, or catalogs.')}}
            <span class="meta-limit">{{__('Max 100MB')}}</span>
        </div>
    </div>
</div>

<!-- ===== STEP 3: MESSAGE BODY ===== -->
<div v-show="currentStep === 3">
    <h2 class="step-title"><i class="fas fa-comment-dots mr-2" style="color: #25D366;"></i>{{__('Message Body')}}</h2>
    <p class="step-subtitle">{{__('Write the main content of your message. This is what your customers will read.')}}
        <span class="badge" style="background: #25D366; color: white;">{{__('Required')}}</span>
    </p>

    <div class="form-group">
        <label class="form-section-label">{{__('Message Text')}} <span class="text-danger">*</span></label>
        <div class="input-group-premium" :class="{'invalid': bodyText.length > 1024 || bodyRatioError}">
            <textarea id="body" rows="8" v-model="bodyText" class="form-control form-control-premium"
                style="resize: none;"
                placeholder="Write your message here. Use the Add Variable button to insert personalized fields like customer name."></textarea>
        </div>

        <!-- Progress Bar -->
        <div class="mt-2">
            <div class="progress" style="height: 6px;">
                <div class="progress-bar"
                    :class="{'bg-success': bodyText.length <= 800, 'bg-warning': bodyText.length > 800 && bodyText.length <= 1024, 'bg-danger': bodyText.length > 1024}"
                    :style="'width: ' + Math.min((bodyText.length / 1024) * 100, 100) + '%'"></div>
            </div>
            <div class="d-flex justify-content-between mt-1">
                <div>
                    <small v-if="bodyText.length === 0" class="text-muted">
                        <i class="fas fa-lightbulb text-warning"></i> {{__('Start typing your message...')}}
                    </small>
                    <small class="text-danger feedback-message" :class="{'show': bodyText.length > 1024}">
                        <i class="ni ni-fat-remove"></i> {{__('Remove')}} @{{ bodyText.length - 1024 }}
                        {{__('characters')}}
                    </small>
                    <small class="text-danger feedback-message" :class="{'show': bodyRatioError}">
                        <i class="ni ni-fat-remove"></i>
                        {{__('Too many variables! Meta requires about 15-20 characters of text per variable. Add more descriptive content.')}}
                    </small>
                    <small class="text-danger feedback-message" :class="{'show': bodyFormatError}">
                        <i class="ni ni-fat-remove"></i> @{{ bodyFormatError }}
                    </small>
                </div>
                <small class="text-counter"
                    :class="{'text-danger': bodyText.length > 1024, 'text-success': bodyText.length > 0 && bodyText.length <= 1024}">
                    <strong>@{{ bodyText.length }}</strong>/1024
                </small>
            </div>
        </div>

        <div class="field-description">
            <i class="fas fa-info-circle"></i>
            <strong>{{__('💡 Personalization:')}}</strong> {{__('Use')}} <code
                style="background: #25D366; color: white; padding: 2px 6px; border-radius: 4px;">@{{1}}</code>, <code
                style="background: #25D366; color: white; padding: 2px 6px; border-radius: 4px;">@{{2}}</code>,
            {{__('etc. to add customer name, order number, etc.')}}
            <span class="meta-limit">{{__('Max 1024 chars')}}</span>
            <br>
            <small class="warning"><i class="fas fa-exclamation-triangle"></i>
                <strong>{{__('Meta Rule:')}}</strong>
                {{__('Need ~15-20 characters of real text per variable. Example: Hi {1}, your order {2} is ready!')}}</small>
        </div>

        <!-- Formatting Toolbar -->
        <div class="mt-3 p-3 rounded"
            style="background: rgba(37, 211, 102, 0.05); border: 1px solid rgba(37, 211, 102, 0.2);">
            <label class="small font-weight-bold mb-2" style="color: #128C7E;">
                <i class="fas fa-magic mr-1"></i>{{__('Text Formatting Tools')}}
            </label>
            <div class="btn-group d-block">
                <button @click="addBold()" type="button" class="btn btn-outline-dark btn-sm" style="min-width: 80px;">
                    <i class="fas fa-bold"></i> {{__('Bold')}}
                </button>
                <button @click="addItalic()" type="button" class="btn btn-outline-dark btn-sm" style="min-width: 80px;">
                    <i class="fas fa-italic"></i> {{__('Italic')}}
                </button>
                <button @click="addCode()" type="button" class="btn btn-outline-dark btn-sm" style="min-width: 80px;">
                    <i class="fas fa-code"></i> {{__('Code')}}
                </button>
                <button @click="addVariable()" type="button" class="btn btn-sm ml-2"
                    style="background: #25D366; color: white; border: none; min-width: 120px;">
                    <i class="fas fa-plus mr-1"></i>{{__('Add Variable')}}
                </button>
            </div>
            <small class="d-block mt-2 text-muted">
                <i class="fas fa-info-circle"></i> {{__('Click formatting buttons to insert at cursor position.')}}
            </small>
        </div>

        <!-- Body Variable Samples -->
        <div class="mt-3 analysis-box" v-if="bodyVariables">
            <label class="small text-muted font-weight-bold">{{__('Variable Samples')}}</label>
            <p class="small text-muted mb-2">
                {{__('Provide example values for each variable. Meta uses these to review your template.')}}
            </p>
            <div v-for="(v, index) in bodyVariables" class="input-group mb-2">
                <div class="input-group-prepend">
                    <span class="input-group-text bg-white font-weight-bold">@{{v}}</span>
                </div>
                <input v-model="bodyExampleVariable[index]" type="text" class="form-control"
                    placeholder="{{__('e.g. John, ORD-12345, etc.')}}">
            </div>
        </div>
    </div>
</div>

<!-- ===== STEP 4: FOOTER ===== -->
<div v-show="currentStep === 4">
    <h2 class="step-title"><i class="fas fa-shoe-prints mr-2" style="color: #128C7E;"></i>{{__('Footer (Optional)')}}
    </h2>
    <p class="step-subtitle">
        {{__('Add a short footer text at the bottom of your message.')}}
        <span class="badge badge-secondary">{{__('Optional')}}</span>
    </p>

    <div class="form-group">
        <label class="form-section-label">{{__('Footer Text')}}</label>
        <div class="input-group-premium" :class="{'invalid': footerText.length > 60}">
            <input v-model="footerText" type="text" class="form-control form-control-premium pr-5"
                placeholder="{{__('e.g. Reply STOP to unsubscribe')}}" maxlength="60">
            <small class="text-counter position-absolute" style="right: 10px; bottom: 12px; z-index:5;"
                :class="{'text-danger': footerText.length > 60}">
                @{{ footerText.length }}/60
            </small>
        </div>
        <div class="field-description">
            <i class="fas fa-info-circle"></i>
            {{__('Common uses: Unsubscribe instructions, disclaimers, or business info.')}}
            <span class="meta-limit">{{__('Max 60 chars')}}</span>
            <br>
            <small class="warning"><i class="fas fa-exclamation-triangle"></i>
                {{__('No variables allowed in footer!')}}</small>
        </div>
    </div>

    <div class="alert alert-light mt-4">
        <i class="fas fa-lightbulb text-warning mr-2"></i>
        <strong>{{__('Pro Tip:')}}</strong>
        {{__('For marketing templates, consider adding "Reply STOP to unsubscribe" to comply with regulations.')}}
    </div>
</div>

<!-- ===== STEP 5: BUTTONS ===== -->
<div v-show="currentStep === 5">
    <h2 class="step-title"><i class="fas fa-hand-pointer mr-2" style="color: #25D366;"></i>{{__('Interactive Buttons')}}
    </h2>
    <p class="step-subtitle">
        {{__('Add buttons to let customers take action directly from your message.')}}
        <span class="badge badge-secondary">{{__('Optional')}}</span>
    </p>

    <div class="alert" style="background: rgba(37, 211, 102, 0.1); border-left: 4px solid #25D366; color: #2c5f2d;">
        <i class="fas fa-info-circle mr-2"></i>
        <strong>{{__('Button Limits:')}}</strong> {{__('Max 10 buttons total. Max 2 URL buttons. Max 1 Phone button.')}}
    </div>

    <!-- Duplicate Button Text Warning -->
    <div v-if="hasDuplicateButtonText()" class="alert alert-danger mb-4">
        <i class="fas fa-exclamation-triangle mr-2"></i>
        <strong>{{__('Error:')}}</strong>
        {{__('Each button must have unique text. You cannot use the same label for multiple buttons.')}}
    </div>

    <div class="text-center mb-4">
        <div class="dropdown">
            <button class="btn btn-primary dropdown-toggle" type="button" data-toggle="dropdown">
                <i class="fas fa-plus mr-1"></i>{{__('Add Button')}}
            </button>
            <div class="dropdown-menu">
                <a class="dropdown-item" href="#" @click.prevent="addQuickReply()">
                    <i class="fas fa-reply mr-2"></i>{{__('Quick Reply')}}
                    <small class="text-muted d-block">{{__('Let customers respond with one tap')}}</small>
                </a>
                <a class="dropdown-item" href="#" @click.prevent="addVisitWebsite()"
                    :class="{'disabled': vistiWebsite.length>1}">
                    <i class="fas fa-external-link-alt mr-2"></i>{{__('Visit Website')}}
                    <small class="text-muted d-block">{{__('Link to your website')}}</small>
                </a>
                <a class="dropdown-item" href="#" @click.prevent="addCallPhone()" v-if="!hasPhone">
                    <i class="fas fa-phone mr-2"></i>{{__('Phone Number')}}
                    <small class="text-muted d-block">{{__('Let customers call you')}}</small>
                </a>
                <a class="dropdown-item" href="#" @click.prevent="addDynamicUrl()"
                    :class="{'disabled': dynamicUrls.length>1}">
                    <i class="fas fa-link mr-2"></i>{{__('Dynamic URL')}}
                    <small class="text-muted d-block">{{__('Personalized link for each customer')}}</small>
                </a>
            </div>
        </div>
    </div>

    <!-- Quick Replies -->
    <div v-if="quickReplies.length>0" class="mb-4">
        <label class="small font-weight-bold text-muted">
            <i class="fas fa-reply mr-1"></i>{{__('Quick Replies')}}
        </label>
        <div class="field-description mb-2">
            <i class="fas fa-info-circle"></i>
            {{__('Short response buttons. Customers tap to reply instantly.')}}
            <span class="meta-limit">{{__('Max 20 chars each')}}</span>
        </div>
        <div v-for="(v, index) in quickReplies" class="form-group mb-2">
            <div class="input-group input-group-premium"
                :class="{'invalid': v.length > 20, 'valid': v.length > 0 && v.length <= 20}">
                <input v-model="quickReplies[index]" type="text" class="form-control form-control-premium"
                    placeholder="{{__('e.g. Yes, I\'m interested')}}" maxlength="20">
                <div class="input-group-append">
                    <span class="input-group-text bg-white text-muted small">@{{ v.length }}/20</span>
                    <button class="btn btn-outline-danger" type="button" @click="deleteQuickReply(index)"><i
                            class="fas fa-trash"></i></button>
                </div>
            </div>
        </div>
    </div>

    <!-- Website Buttons -->
    <div v-if="vistiWebsite.length>0" class="mb-4">
        <label class="small font-weight-bold text-muted">
            <i class="fas fa-external-link-alt mr-1"></i>{{__('Website Buttons')}}
        </label>
        <div class="field-description mb-2">
            <i class="fas fa-info-circle"></i>
            {{__('Link to your website. URL must start with https://.')}}
            <span class="meta-limit">{{__('Label max 25 chars')}}</span>
        </div>
        <div v-for="(v, index) in vistiWebsite" class="analysis-box mt-0 mb-2">
            <div class="row">
                <div class="col-md-5">
                    <label class="small">{{__('Button Label')}}</label>
                    <input v-model="vistiWebsite[index]['title']" type="text" class="form-control form-control-premium"
                        placeholder="{{__('e.g. Shop Now')}}" maxlength="25"
                        :class="{'is-invalid': vistiWebsite[index]['title'].length > 25}">
                    <small class="text-muted">@{{ vistiWebsite[index]['title'].length }}/25</small>
                </div>
                <div class="col-md-7">
                    <label class="small">{{__('Website URL')}}</label>
                    <div class="input-group-premium"
                        :class="{'invalid': vistiWebsite[index]['url'].length > 0 && !isValidURL(vistiWebsite[index]['url']), 'valid': isValidURL(vistiWebsite[index]['url'])}">
                        <input v-model="vistiWebsite[index]['url']" type="text"
                            class="form-control form-control-premium pr-5" placeholder="https://example.com">
                        <i v-if="isValidURL(vistiWebsite[index]['url'])"
                            class="ni ni-check-bold validation-icon success"></i>
                        <i v-if="vistiWebsite[index]['url'].length > 0 && !isValidURL(vistiWebsite[index]['url'])"
                            class="ni ni-fat-remove validation-icon error"></i>
                    </div>
                </div>
            </div>
            <button class="btn btn-sm btn-link text-danger mt-2 p-0" @click="deleteVisitWebsite(index)">
                <i class="fas fa-trash mr-1"></i>{{__('Remove')}}
            </button>
        </div>
    </div>

    <!-- Dynamic URL Buttons -->
    <div v-if="dynamicUrls.length>0" class="mb-4">
        <label class="small font-weight-bold text-muted">
            <i class="fas fa-link mr-1"></i>{{__('Dynamic URL Buttons')}}
        </label>
        <div class="field-description mb-2">
            <i class="fas fa-info-circle"></i>
            {{__('Personalized URLs with a variable suffix (e.g. order ID).')}}
            <span class="meta-limit">{{__('Label max 25 chars')}}</span>
        </div>
        <div v-for="(v, index) in dynamicUrls" class="analysis-box mt-0 mb-2">
            <div class="row">
                <div class="col-md-4">
                    <label class="small">{{__('Button Label')}}</label>
                    <input v-model="dynamicUrls[index]['text']" type="text" class="form-control form-control-premium"
                        placeholder="{{__('View Order')}}" maxlength="25"
                        :class="{'is-invalid': dynamicUrls[index]['text'].length > 25}">
                </div>
                <div class="col-md-5">
                    <label class="small">{{__('Base URL')}}</label>
                    <div class="input-group-premium"
                        :class="{'invalid': dynamicUrls[index]['url'].length > 0 && !isValidURL(dynamicUrls[index]['url']), 'valid': isValidURL(dynamicUrls[index]['url'])}">
                        <input v-model="dynamicUrls[index]['url']" type="text" class="form-control form-control-premium"
                            placeholder="https://site.com/order/">
                    </div>
                </div>
                <div class="col-md-3">
                    <label class="small">{{__('Sample Suffix')}}</label>
                    <input v-model="dynamicUrls[index]['example']" type="text" class="form-control" placeholder="12345">
                </div>
            </div>
            <button class="btn btn-sm btn-link text-danger mt-2 p-0" @click="deleteDynamicUrl(index)">
                <i class="fas fa-trash mr-1"></i>{{__('Remove')}}
            </button>
        </div>
    </div>

    <!-- Phone Button -->
    <div v-if="hasPhone" class="mb-4">
        <label class="small font-weight-bold text-muted">
            <i class="fas fa-phone mr-1"></i>{{__('Phone Button')}}
        </label>
        <div class="field-description mb-2">
            <i class="fas fa-info-circle"></i>
            {{__('Let customers call your business directly. Must be a REAL phone number in international format.')}}
            <span class="meta-limit">{{__('7-15 digits total')}}</span>
        </div>
        <div class="analysis-box">
            <div class="form-group mb-2">
                <label class="small">{{__('Button Label')}}</label>
                <input v-model="callPhoneButtonText" type="text" class="form-control form-control-premium"
                    placeholder="{{__('e.g. Call Us Now')}}" maxlength="25"
                    :class="{'is-invalid': callPhoneButtonText.length > 25}">
                <small class="text-muted">@{{ callPhoneButtonText.length }}/25</small>
            </div>
            <div class="row">
                <div class="col-4">
                    <label class="small">{{__('Country Code')}}</label>
                    <input v-model="dialCode" type="tel" class="form-control" placeholder="{{__('e.g. 971')}}"
                        oninput="this.value = this.value.replace(/[^0-9]/g, '')"
                        :class="{'is-valid': dialCode.length > 0, 'is-invalid': hasPhone && dialCode.length === 0}">
                </div>
                <div class="col-8">
                    <label class="small">{{__('Phone Number')}}</label>
                    <input v-model="phoneNumber" type="tel" class="form-control" placeholder="{{__('e.g. 501234567')}}"
                        oninput="this.value = this.value.replace(/[^0-9]/g, '')"
                        :class="{'is-valid': phoneNumber.length >= 6, 'is-invalid': hasPhone && phoneNumber.length < 6}">
                </div>
            </div>
            <div class="mt-2 p-2 bg-light rounded">
                <small><i class="fas fa-phone mr-1"></i>{{__('Will be sent as:')}} <strong class="text-primary">+@{{
                        dialCode }}@{{ phoneNumber }}</strong></small>
            </div>
            <small v-if="!isValidPhoneNumber()" class="text-danger d-block mt-1">
                <i class="fas fa-exclamation-triangle"></i>
                {{__('Phone must be 7-15 digits total. Use a REAL phone number!')}}
            </small>
            <button class="btn btn-sm btn-link text-danger mt-2 p-0" @click="deletePhone()">
                <i class="fas fa-trash mr-1"></i>{{__('Remove Phone Button')}}
            </button>
        </div>
    </div>

    <!-- No buttons added message -->
    <div v-if="quickReplies.length === 0 && vistiWebsite.length === 0 && !hasPhone && dynamicUrls.length === 0"
        class="text-center text-muted py-4">
        <i class="fas fa-mouse-pointer fa-3x mb-3" style="opacity: 0.3;"></i>
        <p>{{__('No buttons added yet. Buttons help customers take action!')}}</p>
    </div>
</div>