<!-- Step 1: Basic Info -->
<h2 class="step-title"><i class="fab fa-whatsapp mr-2" style="color: #25D366;"></i>{{__('Basic Information')}}</h2>
<p class="step-subtitle">{{__("Let's start with the essential details for your WhatsApp template.")}}</p>

<!-- Template Name -->
<div class="form-group">
    <label class="form-section-label">
        {{__('Template Name')}} <span class="text-danger">*</span>
        <i class="fas fa-question-circle ml-1" data-toggle="tooltip"
            title="{{__('A unique name to identify this template. Use only lowercase letters, numbers and underscores.')}}"></i>
    </label>
    <div class="input-group-premium" :class="{'invalid': !validation.name && touched.name, 'valid': validation.name}">
        <input v-model="template_name" @blur="touched.name = true" type="text" name="name" id="name"
            class="form-control form-control-premium pr-5" placeholder="{{__('e.g. order_confirmation')}}"
            maxlength="512" required>
        <i v-if="validation.name" class="ni ni-check-bold validation-icon success"></i>
        <i v-if="!validation.name && touched.name" class="ni ni-fat-remove validation-icon error"></i>
    </div>
    <div class="field-description">
        <i class="fas fa-lightbulb"></i>
        {{__('Use lowercase letters, numbers, and underscores only. Spaces will be automatically converted to underscores!')}}
        <span class="meta-limit">{{__('Max 512 chars')}}</span>
        <br><small class="text-muted mt-1"><strong>{{__('Good examples:')}}</strong> welcome_message, order_update,
            promo_discount</small>
    </div>
    <small class="feedback-message text-danger" :class="{'show': !validation.name && touched.name}">
        <i class="fas fa-exclamation-triangle"></i> {{__('Template name must use only: a-z, 0-9, _ (underscores)')}}
    </small>
</div>

<!-- Template Category -->
<div class="form-group">
    <label class="form-section-label">
        {{__('Category')}} <span class="text-danger">*</span>
        <i class="fas fa-question-circle ml-1" data-toggle="tooltip"
            title="{{__('Marketing for promotions, Utility for order updates and transactional messages.')}}"></i>
    </label>
    <div class="input-group-premium" :class="{'valid': validation.category}">
        <select v-model="category" name="category" id="category" class="form-control form-control-premium">
            <option value="MARKETING">📢 {{__('Marketing')}} - {{__('Promotional messages, offers, announcements')}}
            </option>
            <option value="UTILITY">🔧 {{__('Utility')}} - {{__('Order updates, reminders, account info')}}</option>
        </select>
    </div>
    <div class="field-description">
        <i class="fas fa-info-circle"></i>
        <div class="mt-1">
            <strong style="color: #25D366;">📢 {{__('Marketing:')}}</strong>
            {{__('For promotions, ads, new products. May have opt-out requirement.')}}
            <br>
            <strong style="color: #128C7E;">🔧 {{__('Utility:')}}</strong>
            {{__('For transactional updates like orders, appointments, receipts.')}}
        </div>
    </div>
</div>

<!-- Template Language -->
<div class="form-group">
    <label class="form-section-label">
        {{__('Language')}} <span class="text-danger">*</span>
        <i class="fas fa-question-circle ml-1" data-toggle="tooltip"
            title="{{__('Select the language your customers will read this message in.')}}"></i>
    </label>
    <div class="input-group-premium"
        :class="{'invalid': !validation.language && touched.language, 'valid': validation.language}">
        <select v-model="language" @blur="touched.language = true" name="language" id="language"
            class="form-control form-control-premium">
            <option value="">🌍 {{__('Select language...')}}</option>
            @foreach ($languages as $language)
                <option value="{{ $language[1] }}">{{ $language[0] }}</option>
            @endforeach
        </select>
        <i v-if="validation.language" class="ni ni-check-bold validation-icon success"></i>
    </div>
    <div class="field-description">
        <i class="fas fa-globe"></i>
        {{__('Choose the language your customers will read this message in.')}}
        <br><small
            class="text-muted">{{__('💡 This determines how WhatsApp displays the template to users. Choose carefully!')}}</small>
    </div>
    <small class="feedback-message text-danger" :class="{'show': !validation.language && touched.language}">
        <i class="fas fa-exclamation-triangle"></i> {{__('Please select a language to continue')}}
    </small>
</div>