@extends('layouts.app', ['title' => __('Send new campaign')])
@section('head')
    <style>
        /* WhatsApp-Themed Premium UI Styles */
        :root {
            --whatsapp-primary: #25D366;
            --whatsapp-dark: #128C7E;
            --whatsapp-light: #DCF8C6;
            --whatsapp-bg: #ECE5DD;
            --success-green: #25D366;
            --error-red: #DC3545;
            --warning-orange: #FF9800;
        }

        .premium-card {
            border: none;
            border-radius: 16px;
            background: #fff;
            box-shadow: 0 10px 30px rgba(37, 211, 102, 0.08);
            overflow: hidden;
            transition: box-shadow 0.3s ease;
        }

        .premium-card:hover {
            box-shadow: 0 15px 40px rgba(37, 211, 102, 0.12);
        }

        .premium-header {
            background: linear-gradient(135deg, #25D366 0%, #128C7E 100%) !important;
            padding: 20px 30px;
        }

        .premium-header h3 {
            color: #fff !important;
            font-weight: 700;
            letter-spacing: 0.5px;
            margin: 0;
        }

        .form-section-label {
            color: #128C7E;
            text-transform: uppercase;
            font-size: 0.75rem;
            font-weight: 700;
            letter-spacing: 1px;
            margin-bottom: 15px;
            margin-top: 10px;
            display: block;
        }

        /* Input Groups */
        .input-group-premium {
            position: relative;
            background: #fff;
            border: 2px solid #e9ecef;
            border-radius: 8px;
            transition: all 0.3s ease;
            overflow: hidden;
        }

        .input-group-premium:focus-within {
            border-color: var(--whatsapp-primary);
            background: #fff;
            box-shadow: 0 4px 15px rgba(37, 211, 102, 0.15);
            transform: translateY(-2px);
        }

        .input-group-premium.valid {
            border-color: var(--success-green);
            background: rgba(37, 211, 102, 0.02);
        }

        .input-group-premium.invalid {
            border-color: var(--error-red);
            animation: shake 0.5s;
            background: rgba(220, 53, 69, 0.02);
        }

        .form-control-premium {
            border: 1px solid #e9ecef;
            border-radius: 8px !important;
            padding: 12px 15px;
            height: auto;
            font-size: 1rem;
            background: transparent;
            transition: all 0.3s ease;
        }

        .form-control-premium:focus {
            border-color: var(--whatsapp-primary);
            box-shadow: 0 0 0 3px rgba(37, 211, 102, 0.1);
            background: rgba(37, 211, 102, 0.02);
        }

        /* Variable Badge */
        .var-badge {
            background: #e9ecef;
            color: #525f7f;
            padding: 4px 8px;
            border-radius: 4px;
            font-family: monospace;
            font-weight: bold;
            display: inline-block;
            margin-right: 5px;
            margin-bottom: 5px;
        }

        /* Validation Icons */
        .validation-icon {
            position: absolute;
            right: 15px;
            top: 50%;
            transform: translateY(-50%);
            z-index: 10;
            font-size: 1.3rem;
            animation: fadeIn 0.3s ease;
        }

        .validation-icon.success {
            color: var(--success-green);
        }

        .validation-icon.error {
            color: var(--error-red);
            animation: shake 0.5s ease;
        }

        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(-50%) scale(0.8);
            }

            to {
                opacity: 1;
                transform: translateY(-50%) scale(1);
            }
        }

        /* Messages */
        .feedback-message {
            font-size: 0.85rem;
            margin-top: 5px;
            display: block;
            opacity: 0;
            transform: translateY(-10px);
            transition: all 0.3s ease;
        }

        .feedback-message.show {
            opacity: 1;
            transform: translateY(0);
        }

        .text-counter {
            font-size: 0.8rem;
            color: #adb5bd;
            text-align: right;
            margin-top: 4px;
        }

        @keyframes shake {
            0% {
                transform: translateX(0);
            }

            25% {
                transform: translateX(-5px);
            }

            50% {
                transform: translateX(5px);
            }

            75% {
                transform: translateX(-5px);
            }

            100% {
                transform: translateX(0);
            }
        }

        .analysis-box {
            background: rgba(37, 211, 102, 0.05);
            border-left: 4px solid var(--whatsapp-primary);
            padding: 15px;
            border-radius: 8px;
            margin-top: 15px;
            transition: all 0.3s ease;
        }

        .analysis-box:hover {
            background: rgba(37, 211, 102, 0.08);
            transform: translateX(2px);
        }

        /* ===== WIZARD STYLES ===== */
        .wizard-progress {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 30px;
            padding: 0 20px;
            position: relative;
        }

        .wizard-progress::before {
            content: '';
            position: absolute;
            top: 50%;
            left: 0;
            right: 0;
            height: 3px;
            background: #e9ecef;
            transform: translateY(-50%);
            z-index: 0;
        }

        .wizard-step {
            display: flex;
            flex-direction: column;
            align-items: center;
            position: relative;
            z-index: 1;
            cursor: pointer;
        }

        .wizard-step-number {
            width: 45px;
            height: 45px;
            border-radius: 50%;
            background: #e9ecef;
            color: #8898aa;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 700;
            font-size: 1.1rem;
            transition: all 0.3s ease;
            border: 3px solid #fff;
            box-shadow: 0 3px 10px rgba(0, 0, 0, 0.08);
        }

        .wizard-step.active .wizard-step-number {
            background: linear-gradient(135deg, #25D366 0%, #128C7E 100%);
            color: #fff;
            transform: scale(1.15);
            box-shadow: 0 5px 15px rgba(37, 211, 102, 0.3);
        }

        .wizard-step.completed .wizard-step-number {
            background: var(--success-green);
            color: #fff;
            box-shadow: 0 3px 10px rgba(37, 211, 102, 0.2);
        }

        .wizard-step-label {
            margin-top: 8px;
            font-size: 0.75rem;
            font-weight: 600;
            color: #8898aa;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .wizard-step.active .wizard-step-label {
            color: var(--whatsapp-primary);
            font-weight: 700;
        }

        .wizard-step.completed .wizard-step-label {
            color: var(--whatsapp-dark);
        }

        /* Step Content Container */
        .wizard-content {
            min-height: 400px;
        }

        /* Step Navigation Buttons */
        .wizard-nav {
            display: flex;
            justify-content: space-between;
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid #e9ecef;
        }

        .wizard-nav .btn {
            min-width: 120px;
        }

        /* Field Description / Meta Limit Info */
        .field-description {
            background: linear-gradient(135deg, rgba(37, 211, 102, 0.08) 0%, rgba(18, 140, 126, 0.08) 100%);
            border-left: 3px solid var(--whatsapp-primary);
            padding: 12px 15px;
            margin-top: 8px;
            border-radius: 0 8px 8px 0;
            font-size: 0.85rem;
            color: #2c5f2d;
            line-height: 1.6;
        }

        .field-description i {
            color: var(--whatsapp-dark);
            margin-right: 8px;
        }

        .field-description .meta-limit {
            background: var(--whatsapp-primary);
            color: #fff;
            padding: 3px 10px;
            border-radius: 12px;
            font-size: 0.7rem;
            font-weight: 700;
            margin-left: 5px;
            display: inline-block;
        }

        .field-description .warning {
            color: var(--warning-orange);
            font-weight: 600;
        }

        /* Step Title */
        .step-title {
            font-size: 1.5rem;
            font-weight: 700;
            color: #32325d;
            margin-bottom: 10px;
        }

        .step-subtitle {
            color: #8898aa;
            font-size: 0.95rem;
            margin-bottom: 25px;
        }
    </style>
@endsection

@section('content')
    <div class="header pb-8 pt-5 pt-md-8">
        <div class="container-fluid">
            <div class="header-body">
                <h1 class="mb-3 mt--3">{{__('Create new template')}}</h1>
                <div class="row align-items-center pt-2">
                </div>
            </div>
        </div>
    </div>

    <form method="POST" action="{{ route('campaigns.store') }}" id="template_creator" enctype="multipart/form-data">
        @csrf
        <div class="container-fluid mt--7" id="tempplate_managment">

            <!-- ===== WIZARD PROGRESS BAR ===== -->
            <div class="card premium-card mb-4" v-cloak>
                <div class="card-body py-3">
                    <div class="wizard-progress">
                        <div v-for="step in totalSteps" :key="step" class="wizard-step"
                            :class="{ 'active': currentStep === step, 'completed': currentStep > step }"
                            @click="goToStep(step)">
                            <div class="wizard-step-number">
                                <template v-if="currentStep > step">
                                    <i class="fas fa-check"></i>
                                </template>
                                <template v-else>
                                    @{{ step }}
                                </template>
                            </div>
                            <span class="wizard-step-label">@{{ getStepName(step) }}</span>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <!-- Main Form Column -->
                <div class="col-lg-8">
                    <div class="card premium-card">
                        <div class="card-body wizard-content">

                            <!-- Step 1: Basic Info -->
                            <div v-show="currentStep === 1" v-cloak>
                                @include('wpbox::templates.partials.basic')
                            </div>

                            <!-- Steps 2-5: Form Content -->
                            <div v-show="currentStep >= 2 && currentStep <= 5" v-cloak>
                                @include('wpbox::templates.partials.form')
                            </div>

                            <!-- Step 6: Review -->
                            <div v-show="currentStep === 6" v-cloak>
                                <h2 class="step-title"><i class="fas fa-clipboard-check mr-2"></i>{{__('Review & Submit')}}
                                </h2>
                                <p class="step-subtitle">
                                    {{__('Review your template before submitting to Meta for approval.')}}
                                </p>

                                <div class="alert alert-info mb-4">
                                    <i class="fas fa-info-circle mr-2"></i>
                                    {{__('After submission, Meta will review your template. This usually takes a few minutes but can take up to 24 hours.')}}
                                </div>

                                <!-- Summary -->
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="analysis-box mb-3">
                                            <label class="small font-weight-bold text-muted">{{__('Template Name')}}</label>
                                            <p class="mb-0">@{{ template_name || '—' }}</p>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="analysis-box mb-3">
                                            <label class="small font-weight-bold text-muted">{{__('Category')}}</label>
                                            <p class="mb-0">@{{ category }}</p>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="analysis-box mb-3">
                                            <label class="small font-weight-bold text-muted">{{__('Language')}}</label>
                                            <p class="mb-0">@{{ language || '—' }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="analysis-box mb-3" v-if="headerType !== 'none'">
                                    <label class="small font-weight-bold text-muted">{{__('Header')}}</label>
                                    <p class="mb-0" v-if="headerType === 'TEXT'">@{{ headerText || '—' }}</p>
                                    <p class="mb-0" v-else>@{{ headerType }} {{__('media uploaded')}}</p>
                                </div>

                                <div class="analysis-box mb-3">
                                    <label class="small font-weight-bold text-muted">{{__('Message Body')}}</label>
                                    <p class="mb-0" style="white-space: pre-wrap;">@{{ bodyText || '—' }}</p>
                                </div>

                                <div class="analysis-box mb-3" v-if="footerText">
                                    <label class="small font-weight-bold text-muted">{{__('Footer')}}</label>
                                    <p class="mb-0">@{{ footerText }}</p>
                                </div>

                                <div class="analysis-box mb-3"
                                    v-if="quickReplies.length > 0 || vistiWebsite.length > 0 || hasPhone || dynamicUrls.length > 0">
                                    <label class="small font-weight-bold text-muted">{{__('Buttons')}}</label>
                                    <div class="mt-2">
                                        <span v-for="(qr, i) in quickReplies" :key="'qr'+i"
                                            class="badge badge-primary mr-1 mb-1">@{{ qr }}</span>
                                        <span v-for="(wb, i) in vistiWebsite" :key="'wb'+i"
                                            class="badge badge-info mr-1 mb-1">🔗 @{{ wb.title }}</span>
                                        <span v-if="hasPhone" class="badge badge-success mr-1 mb-1">📞 @{{
                                            callPhoneButtonText }}</span>
                                        <span v-for="(du, i) in dynamicUrls" :key="'du'+i"
                                            class="badge badge-warning mr-1 mb-1">🔗 @{{ du.text }}</span>
                                    </div>
                                </div>
                            </div>

                            <!-- Wizard Navigation -->
                            <div class="wizard-nav" v-cloak>
                                <button type="button" class="btn btn-outline-secondary" @click="prevStep()"
                                    :disabled="currentStep === 1">
                                    <i class="fas fa-arrow-left mr-2"></i>{{__('Back')}}
                                </button>

                                <div>
                                    <span class="text-muted mr-3">{{__('Step')}} @{{ currentStep }} {{__('of')}} @{{
                                        totalSteps }}</span>

                                    <button v-if="currentStep < totalSteps" type="button" class="btn btn-primary"
                                        @click="nextStep()" :disabled="!canProceedFromStep(currentStep)">
                                        {{__('Next')}}<i class="fas fa-arrow-right ml-2"></i>
                                    </button>

                                    <button v-if="currentStep === totalSteps" type="button" class="btn btn-success btn-lg"
                                        @click="submitTemplate()" :disabled="!canSubmit || isSending">
                                        <span v-if="isSending"><i
                                                class="fas fa-spinner fa-spin mr-2"></i>{{__('Submitting...')}}</span>
                                        <span v-else><i class="fas fa-paper-plane mr-2"></i>{{__('Submit to Meta')}}</span>
                                    </button>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>

                <!-- Preview Column -->
                <div class="col-lg-4">
                    @include('wpbox::templates.partials.preview')
                </div>
            </div>
        </div>
    </form>
    @include('wpbox::templates.scripts')
@endsection