# Flowmaker Sheets Node & SendEmail Node Setup Guide

## 📊 Sheets Node Setup

### Prerequisites
1. Google Cloud Project with Google Sheets API enabled
2. Service Account or API Key for authentication
3. Google Sheets document with proper permissions

### Step 1: Google Cloud Console Setup

1. **Create/Select Project**
   - Go to [Google Cloud Console](https://console.cloud.google.com)
   - Create a new project or select existing one

2. **Enable Google Sheets API**
   - Navigate to "APIs & Services" > "Library"
   - Search for "Google Sheets API"
   - Click "Enable"

3. **Create Credentials**

   **Option A: Service Account (Recommended)**
   - Go to "APIs & Services" > "Credentials"
   - Click "Create Credentials" > "Service Account"
   - Fill in service account details
   - Click "Create and Continue"
   - Skip role assignment (click "Continue")
   - Click "Done"
   - Click on the created service account
   - Go to "Keys" tab
   - Click "Add Key" > "Create new key"
   - Select "JSON" format
   - Download the JSON file
   - Upload to your server: `storage/google-credentials.json`

   **Option B: API Key (Read Only)**
   - Go to "APIs & Services" > "Credentials"
   - Click "Create Credentials" > "API Key"
   - Copy the API key
   - Click "Restrict Key"
   - Select "Google Sheets API"
   - Save

### Step 2: Google Sheets Setup

1. **Create/Open Google Sheet**
   - Go to [Google Sheets](https://sheets.google.com)
   - Create a new sheet or open existing one

2. **Get Spreadsheet ID**
   - Copy the URL: `https://docs.google.com/spreadsheets/d/SPREADSHEET_ID/edit`
   - Extract the SPREADSHEET_ID from the URL

3. **Share with Service Account** (if using service account)
   - Click "Share" button
   - Add the service account email (from JSON file)
   - Give "Editor" permissions
   - Click "Send"

### Step 3: Configure Sheets Node

1. **Add Sheets Node to Flow**
   - Drag "Sheets Node" from the node palette
   - Connect to your flow

2. **Configure Settings**
   - **Operation**: Choose Read/Write/Update/Create Sheet
   - **Spreadsheet ID**: Paste the spreadsheet ID or URL
   - **Range**: Set range (e.g., A1:B10, Sheet1!A:Z)
   - **Authentication**: Select Service Account or API Key
   - **Response Variable**: Name to store the response

3. **Data Format Examples**
   ```json
   // JSON Format
   [["Name", "Email"], ["John Doe", "john@example.com"]]
   
   // CSV Format
   Name,Email
   John Doe,john@example.com
   Jane Smith,jane@example.com
   
   // Simple Text
   Hello World
   ```

---

## 📧 SendEmail Node Setup

### Prerequisites
1. SMTP server credentials
2. Email account with SMTP access
3. Proper email authentication setup

### Step 1: SMTP Provider Setup

#### Gmail Setup
1. **Enable 2-Factor Authentication**
   - Go to [Google Account Security](https://myaccount.google.com/security)
   - Enable 2-Step Verification

2. **Generate App Password**
   - Go to [App Passwords](https://myaccount.google.com/apppasswords)
   - Select "Mail" and your device
   - Copy the generated 16-character password

3. **SMTP Settings**
   - Host: `smtp.gmail.com`
   - Port: `587` (TLS) or `465` (SSL)
   - Username: Your Gmail address
   - Password: App password (not your regular password)

#### Outlook/Hotmail Setup
- Host: `smtp-mail.outlook.com`
- Port: `587`
- Encryption: `TLS`
- Username: Your Outlook email
- Password: Your Outlook password

#### Yahoo Setup
- Host: `smtp.mail.yahoo.com`
- Port: `587`
- Encryption: `TLS`
- Username: Your Yahoo email
- Password: Your Yahoo password

### Step 2: Global SMTP Configuration (Recommended)

Update your `.env` file:
```env
MAIL_MAILER=smtp
MAIL_HOST=smtp.gmail.com
MAIL_PORT=587
MAIL_USERNAME=your-email@gmail.com
MAIL_PASSWORD=your-app-password
MAIL_ENCRYPTION=tls
MAIL_FROM_ADDRESS=your-email@gmail.com
MAIL_FROM_NAME="Your Company Name"
```

### Step 3: Configure SendEmail Node

1. **Add SendEmail Node to Flow**
   - Drag "SendEmail Node" from the node palette
   - Connect to your flow

2. **Configure Settings**
   - **Recipients**: Set To, CC, BCC emails
   - **Subject**: Email subject line
   - **Body**: Email content (HTML or plain text)
   - **Sender**: From email and name
   - **Attachments**: Add file attachments if needed
   - **Custom SMTP**: Enable if using different provider
   - **Response Variable**: Name to store email response

3. **Variable Examples**
   ```
   To: {{contact_email}}
   Subject: Welcome {{contact_name}}!
   Body: Hello {{contact_name}}, thank you for contacting us.
   ```

---

## 🔧 Installation Commands

### Install Google API Client
```bash
cd modules/Flowmaker
composer require google/apiclient
```

### Update Composer Dependencies
```bash
composer update
```

---

## 🧪 Testing

### Test Sheets Node
1. Create a simple flow with Sheets Node
2. Set operation to "Read"
3. Configure with test spreadsheet
4. Run the flow and check response variable

### Test SendEmail Node
1. Create a simple flow with SendEmail Node
2. Set recipient to your email
3. Configure basic email content
4. Run the flow and check your inbox

---

## 🚨 Troubleshooting

### Sheets Node Issues
- **"Service account credentials file not found"**: Check file path and permissions
- **"Permission denied"**: Ensure service account has access to the sheet
- **"Invalid range"**: Check range format (e.g., A1:B10)

### SendEmail Node Issues
- **"Authentication failed"**: Check SMTP credentials
- **"Connection timeout"**: Verify SMTP host and port
- **"Email not delivered"**: Check spam folder and email content

### Common Solutions
1. **Check file permissions**: Ensure credentials files are readable
2. **Verify API quotas**: Check Google Cloud Console for API limits
3. **Test SMTP settings**: Use email client to verify SMTP works
4. **Check logs**: Review Laravel logs for detailed error messages

---

## 📚 Additional Resources

- [Google Sheets API Documentation](https://developers.google.com/sheets/api)
- [Laravel Mail Documentation](https://laravel.com/docs/mail)
- [Gmail SMTP Settings](https://support.google.com/mail/answer/7126229)
- [Flowmaker Documentation](https://docs.flowmaker.com)

---

## 🆘 Support

For technical support:
1. Check the logs in `storage/logs/laravel.log`
2. Verify all credentials and permissions
3. Test with simple configurations first
4. Contact support with specific error messages