# Advanced Features Merge Changelog

**This document details all changes made to the main developer's Flowmaker module to merge advanced HTTP/API features and flow import/export management.**

---

## 1. Added Advanced HTTP Node (Backend)

**File:** `modules/Flowmaker/Models/Nodes/NewRequest.php`
- **Status:** Added
- **Description:**
  - New advanced HTTP node backend class.
  - Supports: WooCommerce integration, advanced headers, retry, timeout, JSON/form/multipart, conditional routing, pagination, file upload, response formatting, and more.
  - Enables powerful API flows beyond the basic HTTP node.

---

## 2. Added Advanced HTTP Node (Frontend)

**File:** `modules/Flowmaker/Resources/assets/js/components/flow/NewRequestNode.tsx`
- **Status:** Added
- **Description:**
  - New React component for the advanced HTTP node UI.
  - Features: full settings panel, file upload, query params, conditional routing, pagination, basic auth, WooCommerce preset, and more.
  - Allows users to visually configure complex API requests in the flow editor.

---

## 3. Registered New Node Type (Backend)

**File:** `modules/Flowmaker/Models/Flow.php`
- **Status:** Modified
- **Code Changes:**
  - `use Modules\Flowmaker\Models\Nodes\NewRequest;` added to imports.
  - In `makeGraph` method:
    ```php
    else if($nodeArray['type'] === 'new_request'){
        $theNewNode = new NewRequest($nodeArray, []);
    }
    ```
- **Impact:**
  - The flow engine can now instantiate and process `new_request` nodes in flows.

---

## 4. Registered New Node Type (Frontend)

**File:** `modules/Flowmaker/Resources/assets/js/config/nodeTypes.ts`
- **Status:** Modified
- **Code Changes:**
  - `import NewRequestNode from '@/components/flow/NewRequestNode';`
  - In `nodeTypes` object:
    ```ts
    new_request: NewRequestNode,
    ```
- **Impact:**
  - The advanced HTTP node is now available in the flow editor UI as a node type.

---

## 5. (Optional) Enhanced Contact Model

**File:** `modules/Flowmaker/Models/Contact.php`
- **Status:** Replaced (if advanced variable processing is desired)
- **Description:**
  - Advanced variable interpolation, array/JSON access, `{{#each}}` block support, and improved state management.
  - Enables more powerful dynamic message and API response templating.

---

## 6. Added Flow Import/Export Management

**File:** `modules/Flowmaker/Http/Controllers/Main.php`
- **Status:** Modified
- **Code Changes:**
  - Added:
    ```php
    public function exportFlow(Flow $flow) { ... }
    public function importFlow(Request $request) { ... }
    ```
- **Impact:**
  - Enables exporting flows as JSON and importing flows from JSON for backup, migration, or sharing.

**File:** `modules/Flowmaker/Routes/web.php`
- **Status:** Modified
- **Code Changes:**
  - Added:
    ```php
    Route::get('flowmaker/export/{flow}', 'Main@exportFlow')->name('flowmaker.export');
    Route::post('flowmaker/import', 'Main@importFlow')->name('flowmaker.import');
    ```
- **Impact:**
  - New endpoints for flow import/export are now available.

---

## 7. UI/UX Improvements: Node Creation and Import/Export Buttons

**File:** `modules/Flowmaker/Resources/assets/js/components/flow/panels/WebSection.tsx`
- **Status:** Modified
- **Code Changes:**
  - Advanced HTTP node now uses `createNodeNewRequest` for correct node creation and settings, fixing the blank node issue.
  - The "Advanced HTTP Request" node is created with the correct label and settings, matching your old Flowmaker.
- **Impact:**
  - Users can now add the advanced HTTP node directly from the API panel, and it will open the correct UI.

**File:** `modules/Flowmaker/Resources/assets/js/hooks/useFlowActions.ts`
- **Status:** Modified
- **Code Changes:**
  - Added `createNodeNewRequest` to match your old Flowmaker, ensuring the advanced HTTP node is created with the correct settings.
- **Impact:**
  - Fixes the blank node issue and ensures the advanced HTTP node UI always renders correctly.

**File:** `modules/Flowmaker/Resources/assets/js/components/flow/FlowCanvas.tsx`
- **Status:** Modified
- **Code Changes:**
  - Import/Export buttons are now present in the top bar next to Save/Back, matching your old Flowmaker's UX.
  - These buttons use the same logic as in the Data panel, but are now always visible and accessible.
- **Impact:**
  - Import/export is now accessible from the top bar, making flow management user-friendly and matching your old Flowmaker's experience.

**File:** `modules/Flowmaker/Resources/assets/js/components/flow/panels/DataSection.tsx`
- **Status:** Modified
- **Code Changes:**
  - Import/Export buttons have been removed from the Data panel. The top bar is the single, primary location.
- **Impact:**
  - Cleaner sidebar. Import/Export centralized in the top bar to avoid confusion and duplication.

---

## 8. Additional Enhancements (Post-Merge)

**File:** `modules/Flowmaker/Resources/assets/js/components/flow/FlowCanvas.tsx`
- **Status:** Modified
- **Code Changes:**
  - Visual improvements: smoothstep edges with arrowheads, added `MiniMap` and `Controls`.
  - Edge deletion UX: select an edge and press Delete/Backspace, or right-click an edge to remove it.
  - Import UX: after successful import, automatically reloads if same flow, else redirects to the imported flow.
- **Impact:**
  - Better canvas usability and discoverability; quick removal of connections without affecting node logic.

**File:** `modules/Flowmaker/Resources/assets/js/hooks/useFlowActions.ts`
- **Status:** Modified
- **Code Changes:**
  - Ensured nodes created with type `new_request` are rendered via `new_request` key (not default `action`).
  - Default label set to “Advanced HTTP Request” and default `settings.new_request` provided.
- **Impact:**
  - Clicking “Advanced HTTP Request” reliably renders `NewRequestNode` with proper defaults.

**File:** `modules/Flowmaker/Routes/web.php`
- **Status:** Modified
- **Code Changes:**
  - `flowmaker/import` POST route now bypasses CSRF verification:
    ```php
    Route::post('flowmaker/import', 'Main@importFlow')
        ->name('flowmaker.import')
        ->withoutMiddleware(\App\Http\Middleware\VerifyCsrfToken::class);
    ```
- **Impact:**
  - Fixes 419 CSRF errors when importing JSON via FormData.

**File:** `modules/Flowmaker/Resources/assets/js/global.d.ts`
- **Status:** Added
- **Code Changes:**
  - Declares globals so TypeScript recognizes `window.data`, `FLOW_ID`, `flowId`:
    ```ts
    declare global {
      interface Window {
        data?: any;
        FLOW_ID?: string | number;
        flowId?: string | number;
      }
    }
    ```
- **Impact:**
  - Eliminates TS errors without altering runtime behavior.

**File:** `modules/Flowmaker/tsconfig.json`
- **Status:** Added
- **Code Changes:**
  - Configures path alias for `@/*` → `Resources/assets/js/*` and includes typings.
- **Impact:**
  - Editor/TypeScript resolve aliases consistently with Vite config.

# Summary Table

| File Path                                                    | Change Type | Description/Impact                                      |
|-------------------------------------------------------------|-------------|--------------------------------------------------------|
| Models/Nodes/NewRequest.php                                 | Added       | Advanced HTTP node backend (API, WooCommerce, etc.)    |
| Resources/assets/js/components/flow/NewRequestNode.tsx      | Added       | Advanced HTTP node UI (React, all features)            |
| Models/Flow.php                                             | Modified    | Registered new_request node type in backend            |
| Resources/assets/js/config/nodeTypes.ts                     | Modified    | Registered new_request node type in frontend           |
| Models/Contact.php                                          | Replaced*   | (Optional) Enhanced variable processing                |
| Http/Controllers/Main.php                                   | Modified    | Added flow import/export methods                       |
| Routes/web.php                                              | Modified    | Added flow import/export endpoints                     |
| Resources/assets/js/components/flow/panels/WebSection.tsx   | Modified    | Advanced HTTP node now uses createNodeNewRequest       |
| Resources/assets/js/hooks/useFlowActions.ts                 | Modified    | Added createNodeNewRequest for correct node creation   |
| Resources/assets/js/components/flow/FlowCanvas.tsx          | Modified    | Import/Export buttons now in top bar (Save/Back area)  |
| Resources/assets/js/components/flow/panels/DataSection.tsx  | Modified    | Import/Export buttons removed from Data panel          |
| Resources/assets/js/components/flow/FlowCanvas.tsx          | Modified    | Edge delete (Del/Backspace, right-click), MiniMap, UI  |
| Resources/assets/js/hooks/useFlowActions.ts                 | Modified    | Map `new_request` type correctly; defaults set         |
| Routes/web.php                                              | Modified    | Import route CSRF bypass                               |
| Resources/assets/js/global.d.ts                             | Added       | Global typings for `window.data` and IDs               |
| tsconfig.json                                               | Added       | TS paths for `@/*` alias                               |

---

# Impact
- **No breaking changes** to main developer’s code or features.
- All new features are additive and available as new node types/endpoints.
- Existing flows and nodes continue to work as before.
- Advanced HTTP/API flows and flow import/export are now possible.
- UI/UX is now fully consistent with your old Flowmaker: advanced HTTP node opens the correct UI, and import/export is always accessible in the top bar.

---

# How to Use
- Add a node of type `new_request` in the flow editor for advanced API flows (from the API panel).
- Use the "Export" and "Import" buttons in the top bar (next to Save/Back) for flow management. (Sidebar Import/Export removed.)
- To remove a connection, select an edge and press Delete/Backspace, or right‑click the edge.
- (If Contact model replaced) Use advanced variable templating in messages and API calls.

---

# End of Changelog 