<?php

namespace Modules\Flowmaker\Models\Nodes;

use Illuminate\Support\Facades\Log;
use Modules\Flowmaker\Models\Contact;

class End extends Node
{
    public function process($message, $data)
    {
        // Reset flow state when flow ends
        $contact = $data->contact;
        if ($contact) {
            $contact->resetFlowState();
            Log::info('Flow completed, state reset', [
                'contact_id' => $contact->id,
                'flow_id' => $this->flow_id
            ]);
        }
        
        // Original end node logic
        return null;
    }

    protected function getNextNodeId($param=null)
    {
        // End node has no next node to process
        return null;
    }
}
