"use strict";
exports.sv = void 0;
var _index = require("./sv/_lib/formatDistance.js");
var _index2 = require("./sv/_lib/formatLong.js");
var _index3 = require("./sv/_lib/formatRelative.js");
var _index4 = require("./sv/_lib/localize.js");
var _index5 = require("./sv/_lib/match.js");

/**
 * @category Locales
 * @summary Swedish locale.
 * @language Swedish
 * @iso-639-2 swe
 * @author Johannes Ulén [@ejulen](https://github.com/ejulen)
 * @author Alexander Nanberg [@alexandernanberg](https://github.com/alexandernanberg)
 * @author Henrik Andersson [@limelights](https://github.com/limelights)
 */
const sv = (exports.sv = {
  code: "sv",
  formatDistance: _index.formatDistance,
  formatLong: _index2.formatLong,
  formatRelative: _index3.formatRelative,
  localize: _index4.localize,
  match: _index5.match,
  options: {
    weekStartsOn: 1 /* Monday */,
    firstWeekContainsDate: 4,
  },
});
