<?php

use Illuminate\Http\Request;
use Modules\Flowmaker\Http\Controllers\SMTPTestController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:api')->get('/flowmaker', function (Request $request) {
    return $request->user();
});

// SMTP Testing Routes
Route::prefix('flowmaker/smtp')->middleware('auth:api')->group(function () {
    Route::post('/test-credentials', [SMTPTestController::class, 'testCredentials']);
    Route::post('/test-connection', [SMTPTestController::class, 'testConnection']);
    Route::get('/provider-suggestions', [SMTPTestController::class, 'getProviderSuggestions']);
});